@echo off
:: idax - ida front end

:: Copyright (c) 2008, 2011 Steven Levine and Associates, Inc.
:: All rights reserved.

:: 2004-08-24 SHL Baseline
:: 2005-05-13 SHL Add idarc
:: 2007-02-07 SHL Relax alias name matching
:: 2007-02-07 SHL Default to 80586p
:: 2008-09-09 SHL Move to devtools
:: 2009-09-06 SHL Rename aliases
:: 2010-06-30 SHL Preset zip_shl history
:: 2010-07-05 SHL Support .os2
:: 2010-10-25 SHL Allow multiple calls without filling path or causing messages
:: 2011-02-22 SHL Use pw

loadbtm on
on errormsg pause

set X=%@diskfree[%_DISK,m]
if %X le 0 .or. %X gt 2147 2gbfix

iff "%@search[ida.exe]" == "" then
  echo on
  call addpath d:\devtools\ida
  @echo off
endiff

:: Add zip_shl to path and history
iff "%@search[zip_shl]" == "" then
  pushd
  do forever
    set X=%@search[zip_shl]
    iff defined X then
      echo on
      call addpath %@path[%X]
      history /a zip_shl
      @echo off
      leave
    endiff
    if %@len[%_CWD] eq 3 leave
    cd ..
  enddo
  popd
endiff

set X=%@expand[*.idb]

:: Set up aliases and history

set Z=
for %Y in ( *.sys *.add *.os2 *.img *.bin *.dll *.exe ) (
  if not defined Z set Z=%Y
)

:: History order is optimized

echo on
history /a ida
@echo off

iff defined Z then
  :: Found executable
  echo on
  alias idarc ida -c -p80586p %Z
  history /a idarc
  history /a idar
  @echo off
  iff not defined X then
    echo on
    alias idan ida -p80586p %Z
    history /a idan
    @echo off
  endiff
else
  :: Did not find executable
  :: New with select
  echo on
  history /a idar
  alias idans `select /[!*.id?,*.nam] /h ida -p80586p (*.*)`
  history /a idans
  :: Assume will need to re-run after cd to directory
  history /a idax
  @echo off
endiff

:: Resume existing .idb
iff defined X then
  echo on
  alias idar `ida` %X
  @echo off
elseiff defined Z then
  echo on
  alias idar `ida` %@name[%Z].idb
  @echo off
else
  echo on
  alias idar `ida %@name[%@word[0,%@expand[%1*.id?]]]`
  @echo off
endiff

pw

:eof
