// MakeCode - convert unexplored code in segs named cseg???

// 18 Feb 2010 Baseline
// 28 Feb 2010 Better progress
// 07 Jun 2010 Comments

#include <idc.idc>

/**
 * analyze one code segment
 */

static analyzeCodeSeg(n, ea, endEa)
{
  auto s;

  s = "Exploring code segment " + n + " between " + form("0x%x", ea) +
      " and " + form("0x%x", endEa);
  Message(s + "\n");			// Put in log
  // Warning(s);			// Enable for debug

  AnalyseArea(ea, endEa);
  Wait();

} // analyzeCodeSeg

/**
 * analyze all code segments
 */

static analyzeCodeSegs()
{
  auto s;
  auto ea;
  auto n;
  auto endEa;

  s = "analyzeCodeSegs starting";
  Message("\n" + s + "\n");		// Put in log

  ea = FirstSeg();

  while (ea != BADADDR) {

    n = SegName(ea);
    if (n == "") {
      s = "Can not find name for segment at " + form("0x%x", ea);
      Message(s + "\n");		// Put in log
      Warning(s);			// Complain
      return;
    }

    endEa = SegEnd(ea) - 1;

    // Assume code segs name cseg??
    if (substr(n, 0, 4) == "cseg")
      analyzeCodeSeg(n, ea, endEa);

    ea = NextSeg(ea);

  } // while

  s = "analyzeCodeSegs finished";
  Message(s + "\n\n");			// Put in log
  // Warning(s);			// Enable for debug

} // analyzeCodeSegs

/**
 * main
 */

static main()
{
  auto s;
  s = "MakeCode starting";
  Message("\n" + s + "\n");		// Put in log
  analyzeCodeSegs();
  s = "MakeCode finished";
  Message(s + "\n\n");			// Put in log
  // Warning(s);			// Show on screen
}
