@Echo off
:: catdebug - set up HOST specific icat environment for debugging icat host
:: Use if problems connecting to MUT

:: 2002-06-04 SHL Baseline
:: 2011-06-07 SHL Comments

echo Setting up ICAT Debug Information

rem  CATDEBUG.CMD - ICAT debug output settings

rem  Typically, the only recognized settings for any of the CAT_DEBUG
rem  environment variables are ALL and/or ON.  Any other setting will
rem  cause the environment variable to be ignored.

rem  CAT_DEBUG - recognized settings are:
rem    ALL - all other settings are ignored and *everything* is output
rem    ON - use the individual settings which follow

set CAT_DEBUG=ON

rem  CAT_DEBUG.IPROBECALLS - recognized settings are:
rem    ALL - individual CAT_DEBUG.IPROBECALL* settings are ignored and
rem            all are assumed ON
rem    ON - use the individual settings for each CAT_DEBUG.IPROBE_CALL*
rem            environment variable

set CAT_DEBUG.IPROBECALLS=ON

rem  The only recognized setting for Individual CAT_DEBUG.IPROBECALL*
rem  variables is ON.  Note that non-SUCCESS return codes are always
rem  output as long as CAT_DEBUG.IPROBECALLS is ALL or ON.
rem    CAT_DEBUG.IPROBECALLBEEP - beep on each iprobe call
rem    CAT_DEBUG.IPROBECALLINPUT - display iprobe_* call input
rem    CAT_DEBUG.IPROBECALLOUTPUT - display iprobe_* call output
rem    CAT_DEBUG.IPROBECALLRC - display all iprobe_* call return codes
rem    CAT_DEBUG.IPROBECALLTIMER - display iprobe_* call elapsed time

set CAT_DEBUG.IPROBECALLBEEP=OFF
set CAT_DEBUG.IPROBECALLINPUT=ON
set CAT_DEBUG.IPROBECALLOUTPUT=ON
set CAT_DEBUG.IPROBECALLRC=ON
set CAT_DEBUG.IPROBECALLTIMER=OFF

rem  The following environment variables control how much info is output
rem  to the debug file during debug file initialization.  The only
rem  recognized setting for each is ON.
rem    CAT_DEBUG.ENVIRONMENT - display ICAT environment variables
rem    CAT_DEBUG.SYSINFO - display ICAT host IP address and OS/2 version

set CAT_DEBUG.ENVIRONMENT=ON
set CAT_DEBUG.SYSINFO=ON

rem  The following environment variables control whether or not the debug
rem  engine can output certain messages.  The only recognized setting for
rem  each is ON.

set CAT_DEBUG.MESSAGE=ON
set CAT_DEBUG.MODULEINFO=ON
set CAT_DEBUG.OBJECTINFO=ON
set CAT_DEBUG.THREADINFO=ON
set CAT_DEBUG.CALLFNINFO=ON

rem === New Stuff for v4.06 ===

set CVK_DEBUG=ALL
