/*rexx                                                               */
/*                                                                   */
/* (C) Copyright IBM Corp. 1993                                       */
/* (C) Copyright IBM Information Solutions 1993                       */
/*                                                                    */
/* Format a VDM Apps User Regs saved on entry to INT21 */

signal on halt name haltexit

arg pdb .

if IsVdm('Current Process is not a VDM') then exit 0

/* user_ss:user_sp */
say ' '

if pdb='' then do

   x=vdmregs()

   address df 'cmd output ln user_sp'
   o=output.0-1
   if left(output.o,1)='&' then do
     address df 'cmd output dw user_sp l2'
     address df 'cmd nssout dw NSS l2'
   end /* do */
   else do
      v86seg=getwords('_Segv86kernel',1)
      if datatype(v86seg,'x') then do
         say 'Unable to locate DOSKRNL - please load kernel symbols'
         exit 0
      end /* do */
      v86seg='&'v86seg':0000'
      say 'Warning: DOSKRNL symbols not loaded'
      say 'Assuming USER_SP at V86GROUP:586 and NSS at V86GROUP:5f2'
      say ''
      address df 'cmd output dw' v86seg'+586 l2'
      address df 'cmd nssout dw' v86seg'+5f2 l2'
   end /* do */
   o=output.0-1
   parse var output.o addr usp uss .
   user_stack='&'uss':'usp
   o=nssout.0-1
   parse var nssout.o addr nss nsp .
   nest_stack='&'nss':'nsp
   say ''
   say 'Registers saved on last entry to INT21 dispatcher:'
   say 'User_SS:User_SP='uss':'usp
   call fmtregs uss,usp
   say ''
   say 'Previous registers if recursing through INT21:'
   say 'NSS:NSP='nss':'nsp
   call fmtregs nss,nsp
end /* do */

/* else format the regs from the uset stack pointer in the PDB */
else do
   address df 'cmd output dw' pdb':2e l2'
   o=output.0-1
   sp=word(output.o,2)
   ss=word(output.o,3)

   say 'Registers formatted from PDB stack assuming INT21 call:'
   say 'PDB_User_Stack='ss':'sp
   call fmtregs ss,sp
end /* do */


haltexit: exit 0

fmtregs: procedure
parse arg ss,sp
address df 'cmd output dw &'ss':'sp 'L0c'
o=output.0-1
parse var output.o . es ip cs fl .
o=o-1
parse var output.o . ax bx cx dx si di bp ds .
sp=right(lower(d2x(x2d(sp)+24)),4,'0')
say 'ax='ax 'bx='bx 'cx='cx 'dx='dx 'sp='sp 'bp='bp 'si='si 'di='di
say 'ds='ds 'es='es 'ss='ss 'cs='cs 'ip='ip fmtflags(fl)
address df 'cmd output u &'cs':'ip'-2 l2'
do i=1 to output.0-1
   if output.i<>'' then say output.i
end /* do */
return

fmtflags: procedure
parse arg flags

fl=''
if length(flags)=8 then do
   eflgs=x2c(left(flags,4))
   flags=right(flags,4)
   if bitand(eflgs,'0000'x)='0001'x then fl=fl 'rf'
   else fl=fl '--'
   if bitand(eflgs,'0002'x)='0002'x then fl=fl 'vm'
   else fl=fl '--'
   if bitand(eflgs,'0004'x)='0004'x then fl=fl 'ac'
   else fl=fl '--'
end /* do */
flags=x2c(flags)
if bitand(flags,'4000'x)='4000'x then fl=fl 'nt'
else fl=fl '--'
if bitand(flags,'0800'x)='0800'x then fl=fl 'ov'
else fl=fl 'nv'
if bitand(flags,'0400'x)='0400'x then fl=fl 'dn'
else fl=fl 'up'
if bitand(flags,'0200'x)='0200'x then fl=fl 'ei'
else fl=fl 'di'
if bitand(flags,'0080'x)='0080'x then fl=fl 'ng'
else fl=fl 'pl'
if bitand(flags,'0040'x)='0040'x then fl=fl 'zr'
else fl=fl 'nz'
if bitand(flags,'0010'x)='0010'x then fl=fl 'ac'
else fl=fl 'na'
if bitand(flags,'0004'x)='0004'x then fl=fl 'pe'
else fl=fl 'po'
if bitand(flags,'0001'x)='0001'x then fl=fl 'cy'
else fl=fl 'nc'
iopl='iopl='left(c2x(bitand(flags,'3000'x)),1)
fl=iopl||fl
return fl

IsVDM: procedure
parse arg msgtxt

address df 'cmd output .p#'
o=output.0-1
if pos('*vdm',output.o)>0 then return 0=0
if msgtxt<>'' then say msgtxt
return 0=1

getwords: procedure
arg address,length
address df "cmd output DW" address "L1"
o=output.0-1
parse var output.o . stor .

do i=1 to length-1
   address df "cmd output DW "address"+"i*2"t L1"
   o=output.0-1
   stor=stor word(output.o,2)
end /* do */
return stor

lower: procedure expose nothing
parse arg str
return translate(str,'abcdefghijklmnopqrstuvwxyz','ABCDEFGHIJKLMNOPQRSTUVWXYZ')


vdmregs: procedure
say ''
address df 'cmd output .r'
say 'Current registers (.r)'
do i=1 to output.0-1
   say output.i
end /* do */

say ' '
address df 'cmd output .pu #'
o=output.0-1
vsf=word(output.o,6)
vsf='%'strip(vsf,'l','%')
address df 'cmd output dd' vsf '+4c l 9'
o=output.0-3
parse var output.o . eip cs fl esp .
o=o+1
parse var output.o . ss es ds fs .
o=o+1
parse var output.o . gs .
ss=right(ss,4)
cs=right(cs,4)
ds=right(ds,4)
es=right(es,4)
fs=right(fs,4)
gs=right(gs,4)

say 'Alternate register set, valid if switching beween V8086 and Protect mode'
say 'cs='cs 'eip='eip 'ss='ss 'esp='esp fmtflags(fl)
say 'ds='ds 'es='es 'fs='fs 'gs='gs
if bitand(x2c(fl),'00020000'x)='00020000'x then mode='&'
else mode='#'
address df 'cmd output u 'mode cs':'eip 'l1'
o=output.0-1
say output.o

return 0


