/*rexx                                                               */
/*                                                                   */
/* (C) Copyright IBM Corp. 1993                                       */
/* (C) Copyright IBM Information Solutions 1993                       */
/*                                                                    */
/* format MDVM information */
numeric digits 18
trace 'o'
?.=''
say ''
address df 'cmd output dd _hmapid l1'
z=output.0-1
firstmapid=word(output.z,2)
if firstmapid='00000000' then say 'There are no VDMs currently active'
else call mapid firstmapid

address df 'cmd output .p#'
z=output.0-1
parse var output.z ?.slot ?.pid ?.ppid ?.csid ?.ord ?.sta ?.pri ?.ptsd ?.pptda ?.ptcb ?.disp ?.sg ?.name .
if ?.name='' then do
   ?.name=?.sg
   ?.sg=?.disp
   ?.disp=''
end /* do */
slot=strip(?.slot,'l','*')
slot=strip(?.slot,'t','#')

if ?.name<>'*vdm' then do
   say 'Current slot is not a VDM'
   exit 4
end /* do */


call loadvars

call mvdmsumm

call fmtdpmi ?.pdhdhostdata

call dosivt

call dosdd ?.dosdd

exit 0

mvdmsumm: procedure expose ?.
say ''
say 'hvdm='?.hvdm 'slot='?.slot 'pid='?.pid 'SG='?.sg 'sta='?.sta 'pri='?.pri 'currentPDB=&'?.curpdb':0'
say 'VDM Protect mode status flVDMStatus='?.flvdmstatus
stat=x2c(?.flvdmstatus)
if bitand(stat,'00000001'x) = '00000001'x then say "   0x00000001 32-bit DPMI app"
if bitand(stat,'00000002'x) = '00000002'x then say "   0x00000002 DPMI app started"
if bitand(stat,'00000004'x) = '00000004'x then say "   0x00000004 VDM in protected mode"
if bitand(stat,'00000008'x) = '00000008'x then say "   0x00000008 V86 on kernel entry"
if bitand(stat,'00000010'x) = '00000010'x then say "   0x00000010 VIF=interrupts enabled"
else say "   0x00000010 VIF=intrrupts disabled"
if bitand(stat,'00000020'x) = '00000020'x then say "   0x00000020 08h hooked"
if bitand(stat,'00000040'x) = '00000040'x then say "   0x00000040 1ch hooked"
if bitand(stat,'00000080'x) = '00000080'x then say "   0x00000080 Protect mode allowed"
if bitand(stat,'00000100'x) = '00000100'x then say "   0x00000100 DOS API extension active"
if bitand(stat,'00000200'x) = '00000200'x then say "   0x00000200 VDM terminating"
if bitand(stat,'00000400'x) = '00000400'x then say "   0x00000200 Virtual EM flag"
if bitand(stat,'00000800'x) = '00000800'x then say "   0x00000800 Task switch for H/W int"
if bitand(stat,'00001000'x) = '00001000'x then say "   0x00001000 VME present"
say ''
say 'VDM status vdmid_flVDM='?.flvdm
stat=x2c(?.flvdm)
if bitand(stat,'0000001'x) = '00000001'x then say "   0x00000001 Virtual Boot Machine"
if bitand(stat,'0000002'x) = '00000002'x then say "   0x00000002 IOPL=3"
if bitand(stat,'0000003'x) = '00000003'x then say "   0x00000003 Title change"
say ''
say 'Dos Emulation Status flVDMDEM='?.flvdmdem
stat=x2c(?.flvdmdem)
if bitand(stat,'0001'x) = '0001'x then say "   0x0001 Slave Thread Present"

call curvpmdata ?.pvpmdata

say 'Linear Arena Head=                  %'?.hla
say 'STI hook head=                      %'?.stih
say 'DOS Kernel Segment=                 &'?.doskseg
say 'DOS Device Driver Head=             &'?.dosdd
say 'IDT limit='?.idtlm '       IDT Base=%'?.ldtbase
say 'flvpmirqhooks=                       '?.flvpmirqhooks
say 'V86 Reflection Hook Head=           %'?.v86reflectionhook
say 'VPM Reflection Hook Head=           %'?.vpmreflectionhook
say 'VPM Exception Return Hook Head=     %'?.vpmexcrethook
say 'VPM Exception Return Hook Head=     %'?.vpmexpexcrethook
say 'V86 Exception Return Hook Head=     %'?.v86expexcrethook
say 'V86 Exception 9 Return Hook Head=   %'?.v86expexc9rethook
say 'Back to V86 Return Hook Head=       %'?.backtov86rethook
say 'Get PSP Return Hook Head=           %'?.getpsprethook


return

curvpmdata: procedure expose ?.
parse arg pvpm

say 'Current DPMI Client instance data:'
call fmtvpmdata pvpm

return

fmtvpmdata: procedure expose ?.
parse arg pvpm

if pvpm<>'00000000' then do
   address df 'cmd output dw %'pvpm'-8 l34'
   z=output.0-7
   if word(output.z,2)='0068' then do
      say ''
      say "DPMI version 1.0 client's instance data at %"pvpm
      pavpmint=word(output.z,7) || word(output.z,6)
      pavpmexc=word(output.z,9) || word(output.z,8)
      z=z+1
      pav86exc=word(output.z,3) || word(output.z,2)
      pvpmidt=word(output.z,5) || word(output.z,4)
      selbios=word(output.z,6)
      selvideo=word(output.z,7)
      savedflvdm=word(output.z,9) || word(output.z,8)
      z=z+1
      parse var output.z . ip ei cs . fl ef sp ep .
      eip=ei||ip
      esp=ep||sp
      eflags=ef||fl
      z=z+1
      parse var output.z . ss . es . ds . fs .
      z=z+1
      parse var output.z . gs .
      pvpmstack=word(output.z,5) || word(output.z,4)
      selvpmstack=word(output.z,6)
      cvpmstack=word(output.z,8) || word(output.z,7)
      oldvpmss=word(output.z,9)
      z=z+1
      oldvpmesp=word(output.z,3) || word(output.z,2)
      hobldt=word(output.z,4)
      bmpldt=word(output.z,5)
      ldtaddr=word(output.z,7) || word(output.z,6)
      idtlim=word(output.z,8)
      t=word(output.z,9)
      z=z+1
      idtaddr=word(output.z,2) || t
      say '  VPM Interrupt shadow table:' pavpmint
      say '  VPM Exception shadow table:' pavpmexc
      say '  V86 Exception shadow table:' pav86exc
      say '  VPM IDT base address:      ' pvpmidt
      say '  BIOS selector:' selbios 'Video selector:' selvideo
      say "  DPMI client's saved flVDMStatus: " savedflvdm
      say ''
      say '  Saved alternate register set (when switching DPMI clients)'
      say '  eip='eip 'cs='cs 'esp='esp 'ss='ss 'eflags='eflags
      say '  ds='ds 'es='es 'fs='fs 'gs='gs
      say ''
      say '  Protect mode locked stack address:' pvpmstack 'selector:' selvpmstack 'use count:' cvpmstack
      say '  Saved protect mode stack ss:esp='oldvpmss':'oldvpmesp
      say ''
      say "  This Client's LDT hob="hobldt 'LDT address='ldtaddr 'LDT valid page bit map='bmpldt
      say "  This Client's IDT address="idtaddr 'IDT limit='idtlim
   end /* do */
   else do
      say ''
      say "DPMI version 0.95 client's instance data at %"pvpm
      pavpmint=word(output.z,7) || word(output.z,6)
      pavpmexc=word(output.z,9) || word(output.z,8)
      z=z+1
      pvpmidt=word(output.z,3) || word(output.z,2)
      selbios=word(output.z,4)
      selvideo=word(output.z,5)
      savedflvdm=word(output.z,7) || word(output.z,6)
      eip=word(output.z,9) || word(output.z,8)
      z=z+1
      parse var output.z . cs . fl ef sp ep ss .
      esp=ep||sp
      eflags=ef||fl
      z=z+1
      parse var output.z . es . ds . fs . gs .
      z=z+1
      pvpmstack=word(output.z,3) || word(output.z,2)
      selvpmstack=word(output.z,4)
      cvpmstack=word(output.z,6) || word(output.z,5)
      oldvpmss=word(output.z,7)
      oldvpmesp=word(output.z,9) || word(output.z,8)
      z=z+1
      hobldt=word(output.z,2)
      bmpldt=word(output.z,3)
      ldtaddr=word(output.z,5) || word(output.z,4)
      idtlim=word(output.z,6)
      idtaddr=word(output.z,8) || word(output.z,7)
      say '  VPM Interrupt shadow table:' pavpmint
      say '  VPM Exception shadow table:' pavpmexc
      say '  VPM IDT base address:      ' pvpmidt
      say '  BIOS selector:' selbios 'Video selector:' selvideo
      say "  DPMI client's saved flVDMStatus: " savedflvdm
      say ''
      say '  Saved alternate register set (when switching DPMI clients)'
      say '  eip='eip 'cs='cs 'esp='esp 'ss='ss 'eflags='eflags
      say '  ds='ds 'es='es 'fs='fs 'gs='gs
      say ''
      say '  Protect mode locked stack address:' pvpmstack 'selector:' selvpmstack 'use count:' cvpmstack
      say '  Saved protect mode stack ss:esp='oldvpmss':'oldvpmesp
      say ''
      say "  This Client's LDT hob="hobldt 'LDT address='ldtaddr 'LDT valid page bit map='bmpldt
      say "  This Client's IDT address="idtaddr 'IDT limit='idtlim
   end /* do */

   if x2d(cvpmstack)>0 then do
      say ''
      address df 'cmd output dl' selvpmstack
      z=output.0-1
      parse var output.z . 'Lim=' limit .
      if bitand(x2c(?.flvdmstatus),'00000001'x)='00000001'x then do
         /* 32-bit client */
         address df 'cmd output dd #'selvpmstack':'limit'-25t l6'
         z=output.0-2
         parse var output.z . ec ip cs ef .
         z=z+1
         parse var output.z . sp ss .
         cs=right(cs,4)
         ss=right(ss,4)
         say '   Entry stack frame to lock stack assuming 32-bit DPMI client exception:'
         say '   Faulting cs:ip='cs':'ip 'ss:sp='ss':'sp 'flags='ef
      end /* do */
      else do
         /* 16-bit client */
         address df 'cmd output dw #'selvpmstack':'limit'-23t l12t'
         z=output.0-2
         parse var output.z . bp msg ofo ofs ro rs ec ip .
         z=z+1
         parse var output.z . cs ef sp ss .
         say '   Entry stack frame to lock stack assuming 16-bit DPMI client exception:'
         say '   Faulting cs:ip='cs':'ip 'ss:sp='ss':'sp 'bp='bp 'flags='ef 'error code='ec
         say '   Post recovery cs:ip='rs':'ro 'Previous Fault Handler cs:ip='ofs':'ofo 'Offset to error msg='msg
      end /* do */
   end /* do */

   call vpmint pavpmint
   call vpmexc pavpmexc

end /* do */
return


fmtdpmi: procedure expose ?.
parse arg pdhd

if pdhd='00000000' then return

address df 'cmd output dw %'pdhd 'l19t'
z=output.0-3

parse var output.z . w1 w2 w3 w4 w5 w6 w7 w8 .
ppdhd=w2||w1
segstk=w3
segenv=w4
segpdb=w5
selss=w6
selds=w7
selcs=w8
z=z+1
parse var output.z . w1 w2 w3 w4 w5 w6 w7 w8 .
selpdb=w1
selenv=w2
pdpmdata=w4||w3
pvpmdata=w6||w5
pdosx=w8||w7
z=z+1
parse var output.z . w1 w2 w3 .
LDTaddr=w2||w1
selvpmbp=w3

say ''
say 'DPMI Host data (DHD) at                      %'pdhd
say '  Parent DHD:                                %'ppdhd
say '  V86 Host Stack Segment:                    ' segstk
say '  V86 Environment Segment:                   ' segenv
say '  V86 PDB Segment:                           ' segpdb
say '  Protect mode SS Selector:                  ' selss
say '  Protect mode DS Selector:                  ' selds
say '  Protect mode CS Selector:                  ' selcs
say '  Protect mode PDB Selector:                 ' selpdb
say '  Protect mode Environment Selector:         ' selenv
say '  DPMI API layer instance data (pdpmdata) at %'pdpmdata
say '  EM86 DMPI instance data at (pvpmdata)      %'pvpmdata
say '  DOS API extension area at                  %'pdosx
say '  LDT address                                %'LDTaddr
say '  Protect Mode Breakpoint Selector           ' selvpmbp

/* call fmtvpmdata pvpmdata */

call fmtdpmi ppdhd

return

dosdd: procedure expose ?.
parse arg pdosdd
if pdosdd='0000:0000' then return
say ''
say 'DOS Loaded Device Drivers'
call fmtdosdd pdosdd

say ''
say 'DOS Internal Device Drivers'
call fmtdosdd ?.doskseg':48'

return

fmtdosdd: procedure expose ?.
parse arg pdosdd

if pdosdd='ffff:ffff' then return

address df 'cmd output .d dev &'pdosdd
do i=1 to output.0-5
   say '   'substr(output.i,8)
end /* do */
z=output.0-9
pdosdd=word(output.z,2)

call fmtdosdd pdosdd

return

mapid: procedure expose ?.
parse arg pmapid
if pmapid='00000000' then return
address df 'cmd output dd %('pmapid') l4'
z=output.0-1
parse var output.z . sg_pid hvdm state pnextmapid .
sg=left(sg_pid,4)
pid=right(sg_pid,4)
desc='VDM Acive'
if state='00000001' then desc='VDM Being Created'
else if state='00000002' then desc='VDM Being Terminated'
else if state='00000003' then desc='VDM Post-creation'
say 'hvdm='hvdm 'pid='pid 'sg='sg 'state='state desc
call mapid pnextmapid
return

vpmint: procedure expose ?.
parse arg pvpmint .

if pvmpexc='00000000' then return
say ''
say '   VPM Shadow Interrupt Handler Table (excluding default BP entries):'

address df 'cmd output dw %'pvpmint'-8 l4'
z=output.0-1
parse var output.z . len sig hob .
if sig<>'5200' then do
   say 'Unable to format table - heap signature does not agree'
   return
end /* do */
entsize=(x2d(len)-8)/256
do entnum=0 to 255
   address df 'cmd output dw %'pvpmint 'l'entsize't/2'
   z=output.0-1
   parse var output.z . offl offh sel flg .
   if sel<>?.selvpmbp then ,
      say '      Interrupt' right(d2x(entnum),2,'0') 'cs:eip='sel':'offh||offl 'CPU flag mask='flg
   pvpmint=d2x(x2d(pvpmint)+entsize)
end /* do */
return

vpmexc: procedure expose ?.
parse arg pvpmexc .

if pvmpexc='00000000' then return
say ''
say '   VPM Shadow Exception Handler Table (excluding default BP entries):'

address df 'cmd output dw %'pvpmexc'-8 l4'
z=output.0-1
parse var output.z . len sig hob .
if sig<>'5200' then do
   say 'Unable to format table - heap signature does not agree'
   return
end /* do */
entsize=(x2d(len)-8)/256
do entnum=0 to 32
   address df 'cmd output dw %'pvpmexc 'l'entsize't/2'
   z=output.0-1
   parse var output.z . offl offh sel flg typ .
   if sel<>?.selvpmbp then ,
      say '      Excption' right(d2x(entnum),2,'0') 'cs:eip='sel':'offh||offl 'flags='flg 'type='right(typ,2)
   pvpmexc=d2x(x2d(pvpmexc)+entsize)
end /* do */
return

dosivt: procedure expose ?.

say 'DOS Interrupt Vector Table'
say ''
do i=0 to 255
   address df 'cmd output dw &0:('i't*4) l2'
   z=output.0-1
   parse var output.z . off seg .
   if sel||off <> '00000000' then say '   Vector='right(d2x(i),2,'0') 'seg:off=&'seg':'off
end /* do */

return

loadvars: procedure expose ?.

address df 'cmd output dd _vdmid_HVDM l1'
z=output.0-1
?.hvdm=word(output.z,2)

address df 'cmd output dd _vdmid_hla l1'
z=output.0-1
?.hla=word(output.z,2)

address df 'cmd output dd _vdmid_flvdm l1'
z=output.0-1
?.flvdm=word(output.z,2)

address df 'cmd output dd _hookheadstih l1'
z=output.0-1
?.stih=word(output.z,2)

address df 'cmd output dw _segv86kernel l1'
z=output.0-1
?.doskseg=word(output.z,2)

address df 'cmd output dw %'?.pptda '+currentpdb-ptda_start l1'
z=output.0-1
?.curpdb=word(output.z,2)

address df 'cmd output dw _vpdosddhead l2'
z=output.0-1
?.dosdd=word(output.z,3)':'word(output.z,2)

address df 'cmd output dw _lidtv86idt l3'
z=output.0-1
?.idtlm=word(output.z,2)
?.ldtbase=word(output.z,4)||word(output.z,3)

address df 'cmd output dd _flVDMStatus l1'
z=output.0-1
?.flvdmstatus=word(output.z,2)

address df 'cmd output dd _pdhdhostdata l1'
z=output.0-1
?.pdhdhostdata=word(output.z,2)

address df 'cmd output dd _pvpmdata l1'
z=output.0-1
?.pvpmdata=word(output.z,2)

address df 'cmd output dd _flvpmirqhooks l1'
z=output.0-1
?.flvpmirqhooks=word(output.z,2)

address df 'cmd output dd _hhookv86reflectionhook l1'
z=output.0-1
?.v86reflectionhook=word(output.z,2)

address df 'cmd output dd _hhookvpmreflectionhook l1'
z=output.0-1
?.vpmreflectionhook=word(output.z,2)

address df 'cmd output dd _hhookvpmexcrethook l1'
z=output.0-1
?.vpmexcrethook=word(output.z,2)

address df 'cmd output dd _hhookvpmexpexcrethook l1'
z=output.0-1
?.vpmexpexcrethook=word(output.z,2)

address df 'cmd output dd _hhookv86expexcrethook l1'
z=output.0-1
?.v86expexcrethook=word(output.z,2)

address df 'cmd output dd _hhookv86expexc9rethook l1'
z=output.0-1
?.v86expexc9rethook=word(output.z,2)

address df 'cmd output dd _hhookbacktov86rethook l1'
z=output.0-1
?.backtov86rethook=word(output.z,2)

address df 'cmd output dd _hhookgetpsprethook l1'
z=output.0-1
?.getpsprethook=word(output.z,2)

address df 'cmd output dd _hhookv86int23hook l1'
z=output.0-1
?.v86int23hook=word(output.z,2)

address df 'cmd output dw _selVPMBP l1'
z=output.0-1
?.selVPMBP=word(output.z,2)

address df 'cmd output dw _flvdmdem l1'
z=output.0-1
?.flvdmdem=word(output.z,2)

return
