/*rexx                                                               */
/*                                                                   */
/* (C) Copyright IBM Corp. 1993                                       */
/* (C) Copyright IBM Information Solutions 1993                       */
/*                                                                    */
/* format ariq and dirq chains */

trace 'o'
signal on halt name haltexit

arg opt .
if opt='?' | opt='/?' then do
   say ''
   say 'Format the IRQ array and PDD interrupt handler entry points'
   say ''
   say 'Syntax: %IRQ </d>'
   say ''
   say 'where:  /d specifies that device driver headers are formatted for each DIRQ'
   exit 0
end /* do */

if opt='/D' then devhdr=0=0
else devhdr=0=1

address df 'cmd output ? airqi'
x=output.0
x=x-1
if word(output.x,2)='error' then do
   say 'os2krnl symbols are not loaded'
   exit 0
end /* do */

address df 'cmd output dd airqi l40'
x=output.0-16
do i=x to output.0-1
   parse var output.i . dirq1 flg1 dirq2 flg2 .
   call fmtirq dirq1 flg1
   call fmtirq dirq2 flg2
end /* do */

haltexit: exit 0

fmtirq: procedure expose devhdr
parse arg dirq flg
if '#'dirq='#00000000' then return
irq=right(flg,4)
flags=left(flg,4)
xf=x2c(flags)
desc=''
if bitand(xf,'0004'x) = '0004'x  then desc = desc 'VDM routable,'
if bitand(xf,'0008'x) = '0008'x  then desc = desc 'NPX int level,'
if bitand(xf,'0010'x) = '0010'x  then desc = desc 'Sharable IRQ,'
if bitand(xf,'0020'x) = '0020'x  then desc = desc 'System IRQ,'
if bitand(xf,'0040'x) = '0040'x  then desc = desc 'Can Shared by more than one DD,'
desc=strip(desc,'l',' ')
desc=strip(desc,'t',',')
say 'IRQ:' irq 'pDIRQ=%'dirq 'flags='flags desc
call fmtdirq dirq
say''
return

fmtdirq: procedure expose devhdr

parse arg dirq .

if '#'dirq='#00000000' then return

address df 'cmd output dd %'dirq 'l4'
x=output.0-1
parse var output.x . nextdirq inth ds_irq freelist .

desc=' pDIRQ=%'dirq 'pLink=%'nextdirq 'DevInt='left(inth,4)':'right(inth,4)
desc=desc 'DevDS='right(ds_irq,4) 'IRQ='left(ds_irq,4) 'Free DIRQ List=%'freelist
say desc
if devhdr then do
   address df 'cmd output .d dev' right(ds_irq,4)':0'
   do i=1 to output.0-1
      say output.i
   end /* do */
end /* do */

call fmtdirq nextdirq
return
