/*
 * 	Interactive disassembler (IDA).
 *	Version 3.06
 *	Copyright (c) 1990-96 by Ilfak Guilfanov. (2:5020/209@fidonet)
 *						  (e-mail: ig@estar.msk.su)
 *	ALL RIGHTS RESERVED.
 *
 */

/*
 *	This file contains internal bit definitions.
 *	Each byte of the program has 32-bit flags
 *	(low 8 bits keep the byte value).
 *	These 32 bits are used in GetFlags/SetFlags functions.
 *	You may freely examine these bits using GetFlags()
 *	but I strongly discourage using SetFlags() function.
 *
 *	The second part of this file contains built-in function
 *	declarations.
 *
 *	This file is subject to change without any notice.
 *	Future versions of IDA may use other definitions.
 */

#ifndef _IDC_IDC
#define _IDC_IDC

//--------------------------------------------------------------------------
#define	BADADDR		0xFFFFFFFFL	// Not allowed address value
#define	MAXADDR		0xFF000000L	// Max allowed address in IDA

//
//	Flag bit definitions (for GetFlags())
//
			
#define MS_VAL	0x000000FFL		// Mask for byte value
#define FF_IVL	0x00000100L		// Byte has value ?

#define hasValue(F)	((F & FF_IVL) != 0)	// any defined value?
#define byteValue(F)	(F & MS_VAL)	// quick replacement for Byte()

#define isLoaded(ea)	hasValue(GetFlags(ea))	// any defined value?

#define MS_CLS  0x00000600L		// Mask for typing
#define FF_CODE 0x00000600L		// Code ?
#define FF_DATA 0x00000400L		// Data ?
#define FF_TAIL 0x00000200L		// Tail ?
#define FF_UNK  0x00000000L		// Unknown ?

#define isCode(F)	((F & MS_CLS) == FF_CODE) // is code byte?
#define isData(F)	((F & MS_CLS) == FF_DATA) // is data byte?
#define isTail(F)	((F & MS_CLS) == FF_TAIL) // is tail byte?
#define isUnknown(F)	((F & MS_CLS) == FF_UNK)  // is unexplored byte?
#define isHead(F)	((F & FF_DATA) != 0)	  // is start of code/data?

//
//	Common bits
//

#define MS_COMM 0x000FF800L		// Mask of common bits
#define FF_COMM 0x00000800L		// Has comment?
#define FF_REF  0x00001000L		// has references?
#define FF_LINE 0x00002000L		// Has next or prev cmt lines ?
#define FF_NAME 0x00004000L		// Has user-defined name ?
#define FF_LABL 0x00008000L		// Has dummy name?
#define FF_FLOW 0x00010000L		// Exec flow from prev instruction?
#define FF_FOP1 0x00020000L		// Has forced operand 1?
#define FF_FOP2 0x00040000L		// Has forced operand 2?
#define FF_VAR  0x00080000L		// Is byte variable ?

#define isFlow	(F)	((F & FF_FLOW) != 0)
#define isFop1	(F)	((F & FF_FOP1) != 0)
#define isFop2	(F)	((F & FF_FOP2) != 0)
#define isVar	(F)	((F & FF_VAR ) != 0)
#define isExtra	(F)	((F & FF_LINE) != 0)
#define isRef	(F)	((F & FF_REF)  != 0)
#define hasName	(F)	((F & FF_NAME) != 0)

#define MS_0TYPE 0x00F00000L		// Mask for 1st arg typing
#define FF_0VOID 0x00000000L		// Void (unknown)?
#define FF_0NUMH 0x00100000L		// Hexadecimal number?
#define FF_0NUMD 0x00200000L		// Decimal number?
#define FF_0CHAR 0x00300000L		// Char ('x')?
#define FF_0SEG  0x00400000L		// Segment?
#define FF_0OFF  0x00500000L		// Offset?
#define FF_0NUMB 0x00600000L		// Binary number?
#define FF_0NUMO 0x00700000L		// Octal number?
#define FF_0ENUM 0x00800000L		// Enumeration?

#define MS_1TYPE 0x0F000000L		// Mask for 2nd arg typing
#define FF_1VOID 0x00000000L		// Void (unknown)?
#define FF_1NUMH 0x01000000L		// Hexadecimal number?
#define FF_1NUMD 0x02000000L		// Decimal number?
#define FF_1CHAR 0x03000000L		// Char ('x')?
#define FF_1SEG  0x04000000L		// Segment?
#define FF_1OFF  0x05000000L		// Offset?
#define FF_1NUMB 0x06000000L		// Binary number?
#define FF_1NUMO 0x07000000L		// Octal number?
#define FF_1ENUM 0x08000000L		// Enumeration?

#define isOff0(F)	((F & MS_0TYPE) == FF_0OFF)
#define isOff1(F)	((F & MS_1TYPE) == FF_1OFF)
#define isChar0(F)	((F & MS_0TYPE) == FF_0CHAR)
#define isChar1(F)	((F & MS_1TYPE) == FF_1CHAR)
#define isSeg0(F)	((F & MS_0TYPE) == FF_0SEG)
#define isSeg1(F)	((F & MS_1TYPE) == FF_1SEG)
#define isDefArg0(F)	((F & MS_0TYPE) != FF_0VOID)
#define isDefArg1(F)	((F & MS_1TYPE) != FF_1VOID)

//
//	Bits for DATA bytes
//

#define DT_TYPE 0xF0000000L		// Mask for DATA typing

#define FF_BYTE 0x00000000L		// byte
#define FF_WORD 0x10000000L		// word
#define FF_DWRD 0x20000000L		// dword
#define FF_QWRD 0x30000000L		// qword
#define FF_TBYT 0x40000000L		// tbyte
#define FF_ASCI 0x50000000L		// ASCII ?
#define FF_STRU 0x60000000L		// Struct ?

//
//	Bits for CODE bytes
//

#define MS_CODE 0xF0000000L
#define FF_PROC 0x10000000L		// proc start
#define FF_ENDP 0x20000000L		// proc end
#define FF_IMMD 0x40000000L		// Has Immediate value ?
#define FF_JUMP 0x80000000L		// Has jump table
#define FF_FAR  0x10000000L		// Far subroutine/location ?

#undef _notdefinedsymbol
#ifdef _notdefinedsymbol // There aren't declarations in IDC, so comment them

	List of built-in functions
	--------------------------

The following conventions are used in this list:
  'ea' is a linear address
  'success' is 0 if a function failed, 1 otherwise
  'void' means that function returns no meaningful value (always 0)

 All function parameter conversions are made automatically.

A. Utility functions
--------------------
long	MK_FP		(long seg,long off);	// the same as [ seg, off ]
long	_lpoke		(long RAMea,long value); // poke a long integer into RAM
						// returns old value
long	_poke		(long RAMea,long value);// poke a byte into RAM
						// returns old value
long	_peek		(long RAMea);		// get a byte from RAM
char	form		(char format,long value); // works as sprintf, takes only
						// 1 parameter. Specifying %f as a parameter
						// will lead to abnormal program termination
						// with bad consequences.
						// The resulting string should
						// be less than 255 characters.
char	substr		(char str,long x1,long x2); // substring [x1..x2-1]
						// if x2 == -1, then till end of line
long	strstr		(char str,char substr);	// find a substring, -1 - not found
long	strlen		(char str);		// calculate length
long	xtol		(char str);		// ascii hex -> number
						// (use long() for atol)
char	atoa		(long ea);		// returns address in
						// the form 'seg000:1234'
success	AssignKey	(char action,long key);	// assign a key to an action
						// meaningful only before the main
						// menu is constructed
success	Jump		(long ea);		// move cursor to ea
						// screen is refreshed at the end
						// of IDC execution
void	Wait		();			// Wait for the end of
						// autoanalysis
void	Exit		(long code);		// Exit to DOS

B. Functions that change program representation
-----------------------------------------------
void	DeleteAll	();			// delete ALL information
						// about the program
long	MakeCode	(long ea);		// convert to instruction
						// returns number of bytes
						// occupied by the instruction
long	AnalyseArea	(long sEA,long eEA);	// analyse area and try to
						// convert to code all bytes
						// Returns 1-ok,0-CtrlBreak pressed
success	MakeName	(long ea,char name);	// assign a name to a location
success	MakeComm	(long ea,char comment);	// give a comment
success	MakeRptCmt	(long ea,char comment);	// give a repeatable comment
success	MakeArray	(long ea,long nitems);	// convert to an array
success	MakeStr		(long ea,long size);	// convert to ASCII string
success	MakeByte	(long ea);		// convert to byte
success	MakeWord	(long ea);		// convert to word
success	MakeDword	(long ea);		// convert to double-word
success	MakeQword	(long ea);		// convert to quadro-word
success	MakeTbyte	(long ea);		// convert to 10 bytes (tbyte)
void	MakeUnkn	(long ea,long expand);	// convert to 'unknown'
						// expand==1 => undefine consequent
						// instructions too
success	OpBinary	(long ea,int n);	// make operand binary
success	OpOctal		(long ea,int n);	// make operand octal
success	OpDecimal	(long ea,int n);	// make operand decimal
success	OpHex		(long ea,int n);	// make operand hex
success	OpChr		(long ea,int n);	// make operand character
success	OpOff		(long ea,int n,long segbase); // make operand offset
						// if segbase==BADADDR, then operand isn't offset
success	OpSeg		(long ea,int n);	// make operand segment
success	OpNumber	(long ea,int n);	// make operand number
success	OpAlt1		(long ea,char opnd);	// manually enter 1st operand
success	OpAlt2		(long ea,char opnd);	// manually enter 2nd operand
void	MakeVar		(long ea);		// the location is 'variable'
void	ExtLinA		(long ea,long n,char line); // insert an additional line before the generated ones
void	ExtLinB		(long ea,long n,char line); // insert an additional line after the generated ones
void	DelExtLnA	(long ea,long n);	// delete an additional line before the generated ones
void	DelExtLnB	(long ea,long n);	// delete an additional line aftr  the generated ones
success	JmpTable	(long jmpea,long tableea,long nitems);	// define a jump table
void	PatchByte	(long ea,long value);	// change a byte
void	SetFlags	(long ea,long flags);	// change internal flags for ea
success	SetReg		(long ea,char reg,long value); // set value of segment register
void	AutoMark	(long ea,long type);	// plan address to analyse:
#endif

#define AU_UNK  10	// make unknown
#define AU_CODE 20	// convert to instruction
#define AU_PROC 30	// make function
#define AU_USED 40	// reanalyse

#ifdef _notdefinedsymbol

C. Functions that produce output files
--------------------------------------
void	WriteMap	(char file);		// produce a .map file
void	WriteTxt	(char file,long ea1,long ea2); // produce an .asm file
void	WriteExe	(char file);		// produce an executable file

D. Informational functions
--------------------------
long	GetFlags	(long ea);		// get internal flags for ea
long	Byte		(long ea);		// get a byte at ea
long	Word		(long ea);		// get a word (2 bytes) at ea
long	Dword		(long ea);		// get a double-word (4 bytes) at ea
long	LocByName	(char name);		// BADADDR - no such name
long	SegByBase	(long base);		// BADADDR - no such segment
long	MinEA		();			// the minimal address defined in the program
long	MaxEA		();			// the maximal address defined in the program
long	BeginEA		();			// where execution starts
long	ScreenEA	();			// the current screen ea
long	SelStart	();			// the selected area start ea
						// BADADDR - no selected area
long	SelEnd		();			// the selected area end ea
						// BADADDR - no selected area
long	GetReg		(long ea,char reg);	// get segment register value
						// BADADDR - undefined or error
long	NextAddr	(long ea);		// returns next defined address
						// BADADDR if no such address exists
long	PrevAddr	(long ea);		// returns prev defined address
						// BADADDR if no such address exists
long	NextHead	(long ea);		// returns next defined item address
						// BADADDR if no such address exists
long	PrevHead	(long ea);		// returns prev defined item address
						// BADADDR if no such address exists
long	NextNotTail	(long ea);		// returns next not tail address
						// BADADDR if no such address exists
long	PrevNotTail	(long ea);		// returns prev not tail address
						// BADADDR if no such address exists
long	ItemEnd		(long ea);		// returns address past end of
						// the item
long	ItemSize	(long ea);		// returns item size, min answer=1
char	Name		(long ea);		// get name of the byte
char	GetMnem		(long ea);		// get instruction name
char	GetOpnd		(long ea,long n);	// get instruction operand
						// n=0 - first operand
long	GetOpType	(long ea,long n);	// get operand type
						// n=0 - first operand
						// Returns:
						// -1	bad operand number passed
						// 0	None
						// 1	General Register (al,ax,es,ds...)
						// 2	Memory Reference
						// 3	Base + Index
						// 4	Base + Index + Displacement
						// 5	Immediate
						// 6	Immediate Far Address
						// 7	Immediate Near Address
						// 8	FPP register
						// 9	386 control register
						// 10	386 debug register
						// 11	386 trace register
						// 12	Condition (for Z80)
						// 13	bit (8051)
						// 14	bitnot (8051)
char	LineA		(long ea,long num);	// get additional line before generated ones
char	LineB		(long ea,long num);	// get additional line after generated ones
char	Comment		(long ea);		// get comment
char	RptCmt		(long ea);		// get repeatable comment
char	AltOp1		(long ea);		// get manually entered 1st operand
char	AltOp2		(long ea);		// get manually entered 2nd operand
//
//	The following functions search for the specified byte
//		ea - address to start from
//		flag |=1 - search forward
//		flag |=2 - search case-sensitive (only for FindText)
//	return BADADDR - not found
//
long	FindVoid	(long ea,long flag);
long	FindCode	(long ea,long flag);
long	FindData	(long ea,long flag);
long	FindProc	(long ea,long flag);
long	FindUnexplored	(long ea,long flag);
long	FindExplored	(long ea,long flag);
long	FindImmediate	(long ea,long flag,long value);
long	FindText	(long ea,long flag,long y,long x,char str);
		// y - number of text line at ea to start from (0..100)
		// x - x coordinate in this line
long	FindBinary	(long ea,long flag,char str);
		// str - a string as a user enters it for Search Text in Core
		//	example:  "0x41 0x42" - find 2 bytes 41h,42h

E. Functions that change global settings
----------------------------------------
long	StringEnd	(long asciiendchar);	// set current ASCII end character
						// returns old value
long	StringStp	(long asciistopchar);	// set current ASCII break character
						// returns old value
long	LowVoids	(long lowlimit);	// set current low limit for voids
						// returns old value
long	HighVoids	(long highlimit);	// set current high limit for voids
						// returns old value
long	TailDepth	(long taildepth);	// set current tail depth
						// returns old value
long	Direction	(long direction);	// set current search direction
						// returns old value
long	Analysis	(long analysis);	// enable/disable auto analysis
						// returns old value
long	Tabs		(long tabulations);	// enable/disable tabulations in output file
						// returns old value
long	Comments	(long comments);	// enable/disable automatic comments
						// returns old value
long	Voids		(long voids);		// enable/disable void marks display
						// returns old value
long	XrefShow	(long xrefshow);	// set number of cross-references to display
						// returns old value
long	Indent		(long indent);		// set indention for instruntions
						// returns old value
long	CmtIndent	(long cmtindent);	// set indention for comments
						// returns old value
long	AutoShow	(long autoshow);	// enable/disable autoanalysis display
						// returns old value
success	SetPrcsr	(char processor);	// set processor type

F. Functions that interact with the user
----------------------------------------
char	AskStr		(char defval,char prompt); // ask a string
long	AskAddr		(long defval,char prompt); // BADADDR - no or bad input
long	AskSeg		(long defval,char prompt); // BADADDR - no or bad input
char	AskIdent	(char defval,char prompt);
void	Message		(char str);		// show a message in messages window
void	Warning		(char str);		// show a warning a dialog box
void	Fatal		(char str);		// exit IDA immediately

G. Functions that work with segments
------------------------------------
long	FirstSeg	();			// returns start of the first
						// segment, BADADDR - no segments
long	NextSeg		(long ea);		// returns start of the next
						// segment, BADADDR - no more segs
long	SegStart	(long ea);		// returns start of the segment
						// BADADDR if bad address passed
long	SegEnd		(long ea);		// return end of the segment
						// this address doesn't belong
						// to the segment
						// BADADDR if bad address passed
char	SegName		(long ea);		// returns name of the segment
						// "" if bad address passed
success	SegCreate	(long startea,long endea,long base,long use32,long alignment,long combination);
success	SegDelete	(long segea,long disable);	// disable=1: exclude all bytes of the segment
							// from the disassembled text.
success	SegBounds	(long segea,long startea,long endea);
success	SegRename	(long segea,char name);
success	SegClass	(long segea,char class);
success	SegAlign	(long segea,long alignment);
#endif
	#define saAbs	   0	// Absolute segment.
	#define saRelByte  1	// Relocatable, byte aligned.
	#define saRelWord  2	// Relocatable, word (2-byte, 16-bit) aligned.
	#define saRelPara  3	// Relocatable, paragraph (16-byte) aligned.
	#define saRelPage  4	// Relocatable, aligned on 256-byte boundary (a "page"
	                	// in the original Intel specification).
	#define saRelDble  5	// Relocatable, aligned on a double word (4-byte)
	                	// boundary. This value is used by the PharLap OMF for
        	        	// the same alignment.
	#define saRel4K    6	// This value is used by the PharLap OMF for page (4K)
	                	// alignment. It is not supported by LINK.
#ifdef _notdefinedsymbol
success	SegComb		(long segea,long combination);
#endif
	#define scPriv     0    // Private. Do not combine with any other program
                        	// segment.
	#define scPub      2    // Public. Combine by appending at an offset that meets
        	        	// the alignment requirement.
	#define scPub2     4    // As defined by Microsoft, same as C=2 (public).
	#define scStack    5    // Stack. Combine as for C=2. This combine type forces
	                	// byte alignment.
	#define scCommon   6    // Common. Combine by overlay using maximum size.
	#define scPub3     7    // As defined by Microsoft, same as C=2 (public).
#ifdef _notdefinedsymbol
success	SegAddrng	(long segea,long addrng);
long	SegByName	(char segname);		// returns segment base
success	SegDefRef	(long segea,char reg,long value);
						// set default value for segment reg

H. Cross-references
-------------------

//	Flow types:
#endif
#define fl_CF	16		// Call Far
#define fl_CN	17		// Call Near
#define fl_JF	18		// Jump	Far
#define fl_JN	19		// Jump	Near
#define fl_US	20		// User specified
#define fl_F	21		// Ordinary flow
#ifdef _notdefinedsymbol
					// Mark exec flow 'from' 'to'
void	Rflow	(long From,long To,long flowtype);
long	Ruflow	(long From,long To,int undef);// Unmark exec flow 'from' 'to'
					// undef - make 'To' undefined if no
					//	  more references to it
					// returns 1 - planned to be
					// made undefined

// The following functions include the ordinary flows:
long	Rfirst	(long From);		// Get first xref from 'From'
long	Rnext	(long From,long current);// Get next xref from
long	RfirstB	(long To);		// Get first xref to 'To'
long	RnextB	(long To,long current);	// Get next xref to 'To'

// The following functions don't take into account the ordinary flows:
long	Rfirst0	(long From);
long	Rnext0	(long From,long current);
long	RfirstB0(long To);
long	RnextB0	(long To,long current);

//	Data reference types:
#endif
#define dr_O	1			// Offset
#define dr_W	2			// Write
#define	dr_R	3			// Read
#define	dr_T	4			// Text (names in manual operands)
#ifdef _notdefinedsymbol

void	setDref	(long From,long To,long drefType);	// Mark Data Ref
void	delDref	(long From,long To);	// Unmark Data Ref

long	Dfirst	(long From);		// Get first refered address
long	Dnext	(long From,long current);
long	DfirstB	(long To);		// Get first referee address
long	DnextB	(long To,long current);

long	XrefType(void);			// returns type of the last xref
					// obtained by [RD]first/next[B0]
					// functions. Return values
					// are fl_... or dr_...
I. Functions that work with files
---------------------------------

***********************************************
** open a file
	arguments: similiar to C fopen()
	returns:	0 -error
			otherwise a file handle

long	fopen		(char file,char mode);

***********************************************
** close a file
	arguments:	file handle
	returns:	nothing

void	fclose		(long handle);

***********************************************
** get file length
	arguments:	file handle
	returns:	-1 - error
			otherwise file length in bytes

long	filelength	(long handle);

***********************************************
** set cursor position in the file
	arguments:	handle	- file handle
			offset	- offset from origin
			origin	- 0 = from start of file
				  1 = from current cursor position
				  2 = from end of file
	returns:	0 - ok
			otherwise error

long	fseek		(long handle,long offset,long origin);

***********************************************
** get cursor position in the file
	arguments:	file handle
	returns:	-1 - error
			otherwise current cursor position

long	ftell		(long handle);

***********************************************
** load file into IDA database
	arguments:	handle	- file handle
			pos	- position in the file
			ea	- linear address to load
			size	- number of bytes to load
	returns:	0 - error
			1 - ok

success	loadfile	(long handle,long pos,long ea,long size);

***********************************************
** save from IDA database to file
	arguments:	handle	- file handle
			pos	- position in the file
			ea	- linear address to save from
			size	- number of bytes to save
	returns:	0 - error
			1 - ok

success	savefile	(long handle,long pos,long ea,long size);

***********************************************
** read one byte from file
	arguments:	handle	- file handle
	returns:	-1 - error
			otherwise a byte read.

long	fgetc		(long handle);

***********************************************
** write one byte to file
	arguments:	handle	- file handle
			byte	- byte to write
	returns:	0 - ok
			-1 - error

long	fputc		(long byte,long handle);

***********************************************
** read 2 bytes from file
	arguments:	handle	- file hanlde
			mostfirst 0 - least significant byte is first (intel)
				  1 - most  significant byte is first
	returns:	-1 - error
			otherwise: a 16-bit value

long	readshort	(long handle,long mostfirst);

***********************************************
** read 4 bytes from file
	arguments:	handle	- file hanlde
			mostfirst 0 - least significant byte is first (intel)
				  1 - most  significant byte is first
	returns:	a 32-bit value

long	readlong	(long handle,long mostfirst);

***********************************************
** write 2 bytes to file
	arguments:	handle	- file hanlde
			word	- a 16-bit value to write
			mostfirst 0 - least significant byte is first (intel)
				  1 - most  significant byte is first
	returns:	0 - ok

long	writeshort	(long handle,long word,long mostfirst);

***********************************************
** write 4 bytes to file
	arguments:	handle	- file hanlde
			dword	- a 32-bit value to write
			mostfirst 0 - least significant byte is first (intel)
				  1 - most  significant byte is first
	returns:	0 - ok

long	writelong	(long handle,long dword,long mostfirst);

***********************************************
** read a string from file
	arguments:	handle	- file hanlde
	returns:	a string
			on EOF, returns -1

char	readstr		(long handle);

***********************************************
** write a string to file
	arguments:	handle	- file hanlde
			str	- string to write
	returns:	0 - ok

long	writestr	(long handle,char str);
#endif // _notdefinedsymbol

// Compatibility macros:

#define	OpOffset(ea,base)	OpOff(ea,-1,base)
#define	OpNum(ea)		OpNumber(ea,-1)
#define	OpChar(ea)		OpChr(ea,-1)
#define	OpSegment(ea)		OpSeg(ea,-1)
#define	OpDec(ea)		OpDecimal(ea,-1)
#define	MakeProc(ea,n)		// nothing to do
#define	MakeEndp(ea,n)		// nothing to do

#endif // _IDC_IDC
