@echo off
:: icatx - Configure ICAT to run from current directory and start
:: Runs icatenv.cmd and seticat.cmd

:: Copyright (c) 2011 Steven Levine and Associates, Inc.
:: All rights reserved.

:: 2011-06-06 SHL Baseline

if "%@eval[0]" == "0" goto is4xxx
  echo Must run in 4OS2/4DOS session
  :: 4os2 /c %0 %1 %2 %3 %4 %5 %6 %7 %8 %9
  :: delay 2
  pause
  goto eof
:is4xxx

loadbtm on
on errormsg pause
on break @goto Halted
setlocal

if "%_DOS%" != "OS2" ( echo Must run in 4OS2 session %+ goto BeepCancel )

:: Scan command line

set CFG=

do I = 1 to %#
  set A=%[%I]
  set X=%@substr[%A,0,1]
  iff "%X" == "/" .or. "%X" == "-" then
    :: Got switch
    set X=%@substr[%A,1,260]
    if "%X" == "h" .or. "%X" == "?" goto UsageHelp
    echo Switch %A unexpected
    goto UsageError
  endiff
  :: Got argument
  iff defined CFG then
    echo Only one configuration allowed
    goto UsageError
  elseiff exist %A.cmd then
    set CFG=%A
    iterate
  endiff
  echo Argument %A unexpected
  goto UsageError
enddo
set I=
set A=
set X=

iff not defined CFG set CFG=seticat

:Main

if %@search[icatenv] == "" ( echo Can not find icatenv %+ goto BeepCancel )

if %@search[%CFG] == "" ( echo Can not find %CFG %+ goto BeepCancel )

title icat configured for %CFG

call icatenv

iff "%@search[icatgam]" == "" ( echo icatgam not found in PATH %+ beep %+ cancel )

echo Configuring icat with %CFG

call %CFG

do forever
  echo.
  call askyn Run icatgam now
  if %? gt 1 cancel
  if %? == 0 icatgam
enddo

quit

:: end main

::=== BeepCancel() Beep and cancel ===

:BeepCancel
  beep
  :: drop thru to cancel

::=== Cancel() Handle cancel ===

:Cancel
  @echo off
  cancel 255
  :: end Cancel

::=== Halted() Handle break ===

:Halted
  @echo off
  echo Halted by user
  goto Cancel
  :: end Halted

::=== UsageError() Report usage error ===

:UsageError
  beep
  echo Usage: %@lower[%@name[%0]] `[-h] [-?] [filespec]...`
  cancel
  :: end UsageError

::=== UsageHelp() Display usage help ===

:UsageHelp
  echo.
  echo skelcmd 4OS2 script
  echo.
  echo Usage: %@lower[%@name[%0]] `[-h] [-?] [filespec]...`
  echo.
  echo `  -h -?     Display this message`

  echo.
  echo `  filespec  File to process`
  cancel
  :: end UsageHelp

:eof
