/*rexx                                                               */
/*                                                                   */
/* (C) Copyright IBM Corp. 1993                                       */
/* (C) Copyright IBM Information Solutions 1993                       */
/*                                                                    */
/* Format VDM arean records */
/* 9/5/97 fixed possible acidental exponential comparison */
/* 3 April 1998 added process name and fixed missing ownername */

signal on halt name haltexit

if IsVdm('Current Process is not a VDM') then exit 0

address df 'cmd output ln arena_head'
o=output.0-1
if left(output.o,1)='&' then do
   address df 'cmd output dw arena_head l2'
   o=output.0-1
   arena=word(output.o,2)
   address df 'cmd output dw UMB_HEAD L1'
   o=output.0-1
   umb=word(output.o,2)
end /* do */
else do
   v86seg=getwords('_Segv86kernel',1)
   if datatype(v86seg,'x') then do
      say 'Unable to locate DOSKRNL - please load kernel symbols'
      exit 0
   end /* do */
   v86seg='&'v86seg':0000'
   say ''
   say 'Warning: DOSKRNL symbols not loaded'
   say 'Assuming ARENA_HEAD at V86GROUP:24'
   say 'Assuming UMB_HEAD   at V86GROUP:8c'
   say ''
   address df 'cmd output dw' v86seg'+24 l2'
   o=output.0-1
   arena=word(output.o,2)
   address df 'cmd output dw' v86seg'+8c l1'
   o=output.0-1
   umb=x2d(word(output.o,2))
end /* do */

quit=0=1

say 'seg  size own  name     process'
do until quit
   address df 'cmd output db &'arena':0 l10'
   o=output.0-1
   parse var output.o . b0 b1 b2 b3 b4 . . . . . . . . . . text
   sig=b0
   own=b2||b1
   size=b4||b3
   name= substr(text,9,8)
   owner_name='        '
   if '#'own='#0000' then flag='free'
   else if '#'own='#0008' then flag='System Owned'
   else do
      flag='Process Owned'
      address df 'cmd output da &('own'-1):8'
      o=output.0-1
      owner_name=left(word(output.o,2),8,' ')
   end
   if sig='5a' then do
      flag=flag', last block'
      quit=0=0
   end /* do */
   else if sig<>'4d' then do
      flag=flag', invalid block'
      quit=0=0
   end /* do */
   ard=x2d(arena)
   if ard>=umb then flag=flag', UMB'
   say arena size own name owner_name flag
   arena=lower(right(d2x(ard+x2d(size)+1),4,'0'))
end /* do */



haltexit: exit 0

getwords: procedure
arg address,length
address df "cmd output DW" address "L1"
o=output.0-1
parse var output.o . stor .

do i=1 to length-1
   address df "cmd output DW "address"+"i*2"t L1"
   o=output.0-1
   stor=stor word(output.o,2)
end /* do */
return stor

lower: procedure expose nothing
parse arg str
return translate(str,'abcdefghijklmnopqrstuvwxyz','ABCDEFGHIJKLMNOPQRSTUVWXYZ')

IsVDM: procedure
parse arg msgtxt

address df 'cmd output .p#'
o=output.0-1
if pos('*vdm',output.o)>0 then return 0=0
if msgtxt<>'' then say msgtxt
return 0=1
