@echo off
:: PDumpCtl - ProcDump control front-end
:: Dump named process/pid or run interactive
:: OK to exit to shell and update options
:: fixme to configure multiple apps

:: Copyright (c) 2001, 2009 Steven Levine and Associates, Inc.
:: All rights reserved.

rem $TLIB$: $ &(#) %n - Ver %v, %f $
rem TLIB: $ $

:: 27 Jun 01 SHL Baseline
:: 21 Jan 04 SHL Add -f -x options
:: 14 Jun 05 SHL Add -a option
:: 05 Jul 05 SHL Update usage
:: 08 Jul 05 SHL Support dec/hex pid and quoted name
:: 09 Dec 06 SHL Add sysvm to full mode to allow .m commands
:: 14 Aug 07 SHL Allow dump directory to be specified on command line
:: 14 Aug 07 SHL Look in more places for dump directory
:: 18 Oct 07 SHL Comments
:: 16 Aug 08 SHL Tweak dump directory search
:: 05 Feb 09 SHL Check 4OS2; sync with standards

if "%@eval[0]" == "0" goto is4xxx
  echo Must run in 4OS2/4DOS session
  pause
  goto eof
:is4xxx

loadbtm on
on errormsg pause
on break @goto Halted
setlocal

if "%_DOS%" != "OS2" ( echo Must run in 4OS2 session %+ beep %+ cancel )

:: Scan args, I=num A=value X=scratch

set D=		%+ :: Dump directory
set M=a		%+ :: Auto/Interactive (a/i)
set N=		%+ :: Process name
set P=		%+ :: Process id
set T=n		%+ :: Type - Normal/Full/eXtended

:: N and P mutually exclusive

do I = 1 to %[#]
  set A=%[%I]
  set X=%@substr[%A,0,1]
  iff "%X" eq "/" .or. "%X" eq "-" then
    :: Got switch
    set X=%@lower[%@substr[%A,1,1]]
    iff "%X" == "h" .or. "%X" == "?" then
      goto Help
    elseiff "%X" == "a" then
      set T=a
    elseiff "%X" == "f" then
      set T=f
    elseiff "%X" == "i" then
      set M=i
    elseiff "%X" == "n" then
      set T=n
    elseiff "%X" == "x" then
      set T=x
    else
      echo Switch %X unexpected
      goto Usage
    endiff
  else
    :: Got proc/pid/dir - detect/convert decimal to hex
    set P=%A
    iff '%@left[1,%P]' == '%="' then
      set N=%@strip[%=",%P]
      iff isdir %X then
	set D=%N
	set N=
      else
	set P=
      endiff
    elseiff "%@left[2,%A]" == "0x" then
      set P=%@substr[%P,2,100]
      set X=%@convert[16,16,%P]
      if "%P" != "%X" ( echo Bad PID %+ goto usage )
    elseiff "%@left[2, %P]" == "0n" then
      set P=%@substr[%P,2,100]
      set X=%@convert[10,10,%P]
      if "%P" != "%X" ( echo Bad PID %+ goto usage )
      set P=%@convert[10,16,%P]
    else
      :: Try for hex PID
      set X=%@convert[16,16,%P]
      iff "%P" != "%X" then
	:: Not a pid
	iff isdir %P then
	  set D=%P
	else
	  set N=%P
	endiff
	set P=
      endiff
    endiff
  endiff
enddo

if %M == a if %T != a if "%P %N" == " " ( echo No process/pid selected %+ goto Usage )

:: Set defaults

echo on
pdumpusr reset
@echo off

:: Look for ?:\Dumps directory on drive d:..k:
:: Optimized for me - sorry
:: fixme to check readonly?
set X=d
do while "%D" == ""
  iff %@ready[%X] == 1 then
    iff %@remote[%X] == 0 .and. %@cdrom[%X] == 0 then
      if isdir %X:\Dumps set D=%X:\Dumps
    endiff
  endiff
  if %X == k leave
  if %X == z set X=b
  set X=%@char[%@eval[%@ascii[%X]+1]]
enddo

if "%D" == "" if isdir %TMP\Dumps set D=%TMP\Dumps

iff "%D" == "" then
  echo Dump directory not found - checked ?:\Dumps and %TMP\Dumps
  cancel
endiff

:: Enable dump faclity using user's default settings
echo.
echo on
procdump on /l:%D
@echo off

:: pdumpusr option summary - see \OS2\SYSTEM\RAS\PROCDUMP.DOC
:: summ		Summary for dumped threads (default)
:: syssumm	Summary for all threads
:: idt          Interrupt descriptor table
:: laddr	Linear address range(s)
:: paddr(all)	Add physical memory
:: sysldr	Loader data for all processes
:: sysfs	File System data for all processes (default)
:: sysvm	Virtual Memory data for all processes
:: systk	Task Management related data for all processes
:: private	Private code and data referenced by process
:: shared	Shared code and data referenced by process
:: instance	Instance data referenced by the process.
:: mvdm		MVDM instance data for process (default)
:: sysmvdm	MVDM data for all VDM and the kernel resident heap
:: sem		Semaphore data for all blocked threads in process (default)
:: syssem	SEM data for all blocked threads in system
:: krheaps	Kernel Resident Heaps
:: ksheaps	Kernel Swappable Heaps
:: syspg	Physical and Page Memory management records (PF, VP, PTE, PDE)
:: sysio	IO subsystem structures (AIRQI, DIRQ, PDD eps, PDD chain)
:: trace	System trace buffers
:: strace	STRACE buffer

:: Adjust to command line settings

iff "%T" == "a" then
  :: All physical memory
  echo on
  pdumpusr paddr(all)
  @echo off
endiff

iff "%T" == "f" then
  :: Full
  echo on
  pdumpusr summ,sysldr,sysfs,private,instance,syssem,sysio
  @echo off
endiff

iff "%T" == "x" then
  :: Extended
  echo on
  pdumpusr summ,sysldr,sysfs,private,instance,syssem,sysio
  pdumpusr shared,update
  @echo off
endiff

echo on
procdump query
@echo off

:: Check forced dump request using current settings
iff %M=a then
  procdump query
  iff "%P" != "" then
    echo Dumping PID %P
    procdump force /pid:%P
  elseiff "%N" != "" then
    echo Dumping process %N
    procdump force /proc:%N
  else
    :: Must be paddr(all)
    procdump force /system
  endiff
  procdump off
  procdump query
  quit
endiff

:: Interactive

do forever
  iff "%P" != "" then
    echo PID %P selected
    echo.
  elseiff "%N" != "" then
    echo Process %N selected
    echo.
  endiff
  inkey /k"adfhorsvq!?[Esc][Enter]" `D)ump F)ull S)hared A)ll R)eset V)iew O)ff H)elp Q)uit ? ` %%Z
  echo.
  iff "%Z" == "q" .or. "%Z" == "" then
    leave
  elseiff "%Z" == "@28" then
    iterate
  elseiff %Z == a then
    :: All physical memory
    set T=a
    echo on
    pdumpusr reset
    pdumpusr paddr(all)
    pdumpusr query
    @echo off
  elseiff %Z == d then
    :: Force dump now
    iff "%P" != "" then
      echo Dumping PID %P
      echo on
      procdump force /pid:%P
      @echo off
    elseiff "%N" != "" then
      echo Dumping process %N
      echo on
      procdump force /proc:%N
      @echo off
    elseiff %T == a then
      echo Dumping all memory
      echo on
      :: procdump force /system
      procdump force /pid:all
      @echo off
    else
      echo No process/pid selected
    endiff
  elseiff %Z == f then
    :: Full
    set T=f
    echo on
    :: pdumpusr reset
    pdumpusr summ,sysldr,sysfs,sysvm,private,instance,syssem,sysio,update
    pdumpusr query
    @echo off
  elseiff %Z == o then
    :: Off
    set T=n
    echo on
    procdump off
    @echo off
    echo.
  elseiff %Z == r then
    :: Reset to default
    set T=n
    echo on
    procdump reset /pid:all
    procdump on /l:%D
    pdumpusr reset
    procdump query
    @echo off
  elseiff %Z == v then
    :: Status
    echo on
    procdump query
    @echo off
  elseiff %Z == s then
    :: Add shared
    echo on
    pdumpusr shared,update
    pdumpusr query
    @echo off
  elseiff "%Z" == "!" then
    :: Shell
    echo.
    %comspec
  elseiff "%Z" == "h" .or. "%Z" == "?" then
    :: Help
    echo D - Force dump using current settings
    echo F - Set up for full dump - adds summ,sysldr,sysfs,private,instance,syssem,sysio
    echo S - Add shared code/data to current settings
    echo A - Set up to dump all physical memory with paddr(all) - resets other settings
    echo V - View current settings
    echo O - Turn off dump facility
    echo R - Reset to default settings
    echo H - Display this screen
    echo Q - Quit
    echo ? - Display this screen
    echo ! - Shell
    echo.
  else
    pause Unexpected %Z
    cancel
  endiff
enddo

:quit

:: Show exit state
echo Current process dump settings are
echo.
echo on
procdump query
@echo off

quit

::=== Halted() Handle break ===

:Halted
  @echo off
  echo Halted by user
  goto quit
  :: end Halted

::=== Usage: Report usage error ===

:Usage
  beep
  echo Usage: %@lower[%0] `[-?] [-f] [-h] [-i] [-n] [-x] [procname|hex-pid|dec-pid|dirname]`
  cancel

::=== Help: Show usage help ===

:Help
  echo.
  echo Usage: %@lower[%0] `[-?] [-f] [-h] [-i] [-n] [-x] [procname|hex-pid|dec-pid|dirname]`
  echo.
  echo ` -a        All memory`
  echo ` -f        Full, normal plus system details`
  echo ` -h -?     This message`
  echo ` -n        Normal, use default settings`
  echo ` -i        Run interactive (otherwise force dump and exit)`
  echo ` -x        Extended, full plus shared`
  echo.
  echo ` hex-pid   hex pid, optionally prefix with 0x`
  echo ` dec-pid   decimal pid, prefix with 0n`
  echo ` procname  Process name, quote if name looks like a number`
  echo ` dirname   Dump directory, quote if name looks like a number`
  cancel

:eof
