@echo off
:: os2traceenv - Set up os2 trace environment

:: Copyright (c) 2006, 2010 Steven Levine and Associates, Inc.
:: All rights reserved.

:: This program is free software licensed under the terms of the GNU
:: General Public License.  The GPL Software License can be found in
:: gnugpl2.txt or at http://www.gnu.org/licenses/licenses.html#GPL

:: 2006-01-05 SHL Baseline
:: 2008-08-21 SHL devtool -> devtools
:: 2010-09-25 SHL Check 4OS2
:: 2011-03-02 SHL Support cmd.exe
:: 2011-03-02 SHL Support more known locations

if "%@eval[0]" == "0" goto is4xxx
  goto UsingCmdExe
  goto eof
:is4xxx

loadbtm on
on errormsg pause

if "%_DOS%" != "OS2" ( echo Must run in 4OS2 session %+ beep %+ cancel )

if "%$" == "-h" .or. "%$" == "-?" goto UsageHelp
if %# != 0 goto UsageError

set X=%@search[os2trace]

iff defined X then
  set D=%@path[%X]
  set D=%@left[%@eval[%@len[%D]-1],%D]
  setlocal
  set X=%@index[%PATH;,%D;]
  if %X gt -1 ( echo pmos2trc environment already prepared for %D %+ cancel )
  endlocal
else
  do 1
    set D=%_CWD
    if exist %D\os2trace.exe leave
    set D=%@lower[%_DISK]:\devtools\os2trace
    if exist %D\os2trace.exe leave
    set D=d:\devtools\os2trace
    if %@ready[%D] == 1 if exist %D\os2trace.exe leave
    echo Can not locate os2trace.exe in known locations
    beep
    cancel
  enddo
endiff

:: Augment paths
set PATH=%D;%PATH
set DPATH=.;%D;%DPATH
set HELP=.;%D;%HELP
set BEGINLIBPATH=%D;%BEGINLIBPATH

echo.

echo on
history /a pmos2trc
history /a os2trace
@echo off

echo.

echo environment prepared for os2trace found at %D
set D=
echo Run pmos2trc to trace enable applications

quit

:: end main

::=== Using cmd.exe ==

:UsingCmdExe

set D=d:\devtools\os2trace
if exist %D%\os2trace.exe goto gotexe
set D=d:\os2trace
if exist %D%\os2trace.exe goto gotexe
echo Can not locate os2trace.exe
goto eof
:gotexe

:: Augment paths
set PATH=%D%;%PATH%
set DPATH=.;%D%;%DPATH%
set HELP=.;%D%;%HELP%
set BEGINLIBPATH=%D%;%BEGINLIBPATH%

echo.
echo environment prepared for os2trace found at %D%
set D=
echo Run pmos2trc to trace enable applications

goto eof

:: end UsingCmdExe


::=== UsageError() Report usage error ===

:UsageError
  beep
  echo Usage: %@lower[%0] `[-h] [-?]`
  cancel

::=== UsageHelp() Display usage help ===

:UsageHelp
  echo.
  echo Set up os2trace working environment
  echo.
  echo Usage: %@lower[%0] `[-h] [-?]`
  echo.
  echo `  -h -?     Display this message`
  cancel

:eof
