@echo off
:: icatenv - set up icat environment for system with toolkit installed to d:\toolkit
:: -f force update
:: -m force path clean (minpath)
:: -q force quiet mode - limit progress reporting and bypass window updates
:: -z zap setup
:: ? show current settings

:: Copyright (c) 2011 Steven Levine and Associates, Inc.
:: All rights reserved.

:: 2011-06-06 SHL Baseline

if "%@eval[0]" == "0" goto is4xxx
  echo Must run in 4OS2/4DOS session
  pause
  goto eof
:is4xxx

loadbtm on
on errormsg pause
:: setlocal - do later maybe

if "%_DOS%" != "OS2" ( echo Must run in 4OS2 session %+ beep %+ cancel )

:: Try to be low impact on environment since we can not setlocal yet

for %X in ( F M Q Z ) set %X=
do while %# != 0
  set A=%1
  set X=%@substr[%A,0,1]
  iff "%X" eq "/" .or. "%X" eq "-" then
    :: Got switch
    set X=%@lower[%@substr[%A,1,1]]
    if "%X" == "h" .or. "%X" == "?" goto UsageHelp
    iff "%X" == "f" then
      set F=-f
    elseiff "%X" == "m" then
      set M=-m
    elseiff "%X" == "q" then
      set Q=-q
    elseiff "%X" == "z" then
      set Z=-z
    elseiff "%X" == "-" then
      :: End of local args
      shift /1
      leave
    else
      echo Switch %A unexpected
      goto UsageError
    endiff
    shift /1
    iterate
  endiff
  :: Got argument
  if "%A" == "?" ( gosub ShowSettings %+ goto Quit )
  :: Use remaining args for command line
  leave
enddo

iff defined Z then
  :: Zap setup
  iff not defined ICATBASE .and. not defined F then
    echo ICATBASE not set - nothing to zap
  else
    if defined ICATBASE call delpath -q DPATH %ICATBASE\*
    for %X in ( ICATBASE ) do set %X=
    if %@index[%_WINTITLE,icatos2] gt -1 title %@name[%OS2_SHELL]
    :: If not nested and not quiet
    iff %_BATCH == 1 .and. not defined Q then
      echo icatos2 setup zapped
    endiff
  endiff
  goto Quit
endiff

iff defined ICATBASE .and. not defined F then
  if not defined Q echo ICATBASE already set to %ICATBASE
  goto Quit
endiff

:: If have args preserve local environment
if %# != 0 setlocal

do 1
  set X=\toolkit
  set ICATBASE=D:%X
  if isdir %ICATBASE leave
  set ICATBASE=
enddo

iff not defined ICATBASE then
  echo Can not select icatos2 home directory - can not intialize
  beep
  cancel
endiff

if defined M call minpath %Q
if defined M call minenv %Q

:: REM'ed items are already set by config.sys
:: SET BEGINLIBPATH=%ICATBASE\dll;%BEGINLIBPATH
:: SET PATH=%ICATBASE\bin;%PATH
set DPATH=%ICATBASE\icatos2\help;%DPATH
:: SET HELP=%ICATBASE\help;%HELP

iff %# == 0 then
  :: No args - configure user interface unless suppressed
  iff %_PTYPE == AVIO .or. %_PTYPE == FS .and. not defined Q then
    iff %_BATCH == 1 then
      :: Not nested ...
      title icatos2 %@name[%OS2_SHELL] Shell
      pw
      echo.
      echo on
      history /a icatgam
      @echo off
    endiff
    if %_BATCH == 1 echo %@name[%0] ready
  endiff
  goto Quit
endiff

:: Got args - pass to shell
%$

:: Drop thru to Quit
:: end main

::=== Quit() Clean up and exit ===

:Quit
  gosub Clean
  quit

::=== Clean() Clean up ===

:Clean
  for %X in ( A F M Q Z ) set %X=
  set X=
  return

::=== ShowSettings() Show current settings ===

:ShowSettings
  for %X in ( ICATBASE ) echo %X=%[%X]
  return

::=== UsageError() Report usage error ===

:UsageError
  beep
  echo Usage: %@lower[%0] `[-f] [-h] [-m] [-q] [-z] [-?] [?] [--] [cmd [args...]]`
  gosub Clean
  cancel

::=== UsageHelp() Display usage help ===

:UsageHelp
  echo.
  echo Set up icatos2 environment
  echo.
  echo Usage: %@lower[%0] `[-f] [-h] [-m] [-q] [-z] [-?] [?] [--] [cmd [args...]]`
  echo.
  echo `  -f     Force setup`
  echo `  -h -?  Display this message`
  echo `  -m     Minimize path`
  echo `  -q     Quiet - limit progress reporting and bypass window updates`
  echo `  -z     Zap setup`
  echo `  ?      Show settings`
  echo `  --     End of` %@name[%0] args
  echo.
  echo `  cmd    Command to run`
  echo `  args   Arguments for cmd`
  gosub Clean
  cancel

:eof
