/*rexx                                                               */
/*                                                                   */
/* (C) Copyright IBM Corp. 1993                                       */
/* (C) Copyright IBM Information Solutions 1993                       */
/*                                                                    */
/* list loaded Windows modules and their segment tables */
/* 9/5/97 fixed possible acidental exponential comparison */

signal on halt name haltexit
trace 'o'
arg parms

args=''
opts=''
do while parms<>''
   parse var parms parm parms
   if left(parm,1)='/' then opts=opts||substr(parm,2)
   else args=args parm
end /* do */

fobjects=0=1
exeonly=0=1
libonly=0=1
drvonly=0=1
namesel=0=1
fenttab=0=1
frestab=0=1
fimptab=0=1
fnametab=0=1
verbose=0=1
hExe=''
if words(args)>1 then do
   say 'Invalid parameters'
   call helpmsg
   exit 0
end /* do */
modsel=strip(args,'b',' ')

if pos('?',opts)>0 | modsel='?' then do
   call helpmsg
   exit 0
end /* do */

if pos('E',opts)>0 then fenttab=0=0
if pos('I',opts)>0 then fimptab=0=0
if pos('L',opts)>0 then libonly=0=0
if pos('N',opts)>0 then fnametab=0=0
if pos('O',opts)>0 then fobjects=0=0
if pos('P',opts)>0 then drvonly=0=0
if pos('R',opts)>0 then frestab=0=0
if pos('V',opts)>0 then verbose=0=0
if pos('X',opts)>0 then exeonly=0=0

if left(modsel,1)="'" then do
   modname=strip(modsel,b,"'")
   namesel=0=0
end  /* Do */
else if datatype(modsel,'x') then do
   say 'Invlid paramerers'
   call helpmsg
   exit 0
end  /* Do */
else hExe=modsel

if wininit() then exit 8

nextexe=value('DF_WHEXEHEAD',,'OS2ENVIRONMENT')
if nextexe='' then signal error

if hExe<>'' then hExe=x2d(hExe)

nextexe=x2d(nextexe)
do while nextexe<>0
   if hExe='' then rc=fmtexe(nextexe)
   else if hExe=nextexe then do
      rc=fmtexe(hExe)
      exit 0
   end  /* Do */
   nextexe=getwords('#'nextexe't:6',1)
   if nextexe='' then signal error
   else nextexe=x2d(nextexe)
end /* do */

haltexit: exit 0

error: say 'Unable to process command'
say " "
exit 8

fmtexe: procedure expose fobjects namesel exeonly libonly drvonly,
                  modname fenttab fnametab frestab verbose fimptab
arg exe

finfo=getwords('#'exe't:a',1)
address df 'cmd output da #'exe't:'finfo'+8'
o=output.0-1
name=word(output.o,2)
if (exeonly | libonly | drvonly | namesel) then do
   p=lastpos('\',name)
   sname=substr(name,p+1)
   parse upper var sname sname '.' ext
   select
      when namesel & (sname=modname) then doformat=0=0
      when exeonly & (ext='EXE') then doformat=0=0
      when libonly & (ext='DLL') then doformat=0=0
      when drvonly & (ext='DRV') then doformat=0=0
   otherwise
   doformat=0=1
   end  /* select */
end  /* Do */
else doformat=0=0
if doformat then return 0

tfl=getwords('#'exe't:36',1)
flags=left(tfl,2)
type=right(tfl,2)
select
   when type='00' then type='Any NE '
   when type='01' then type='Default'
   when type='02' then type='Windows'
   when type='03' then type='DOS 4.x'
   when type='04' then type='Win386 '
otherwise
type='UNKNOWN'
end  /* select */

hExe=right(d2x(exe),4,'0')

say 'hExe='hExe 'type='type 'flags='flags name

if verbose then do
   address df 'cmd output db #'exe't:0 l40'
   o=output.0-4
   parse var output.o addr b0 b1 b2 b3 b4 b5 b6 b7'-'b8 b9 ba bb bc bd be bf .
   magic=x2c(b0||b1)
   usage=b3||b2
   enttab=b5||b4
   nextexe=b7||b6
   pautodata=b9||b8
   pfileinfo=bb||ba
   flags=bd||bc
   segauto=bf||be
   o=o+1
   parse var output.o addr b0 b1 b2 b3 b4 b5 b6 b7'-'b8 b9 ba bb bc bd be bf .
   heap=b1||b0
   stack=b3||b2
   csip=b7||b6':'b5||b4
   sssp=bb||ba':'b9||b8
   cseg=bd||bc
   cmod=bf||be
   o=o+1
   parse var output.o addr b0 b1 b2 b3 b4 b5 b6 b7'-'b8 b9 ba bb bc bd be bf .
   cbnrestab=b1||b0
   segtab=b3||b2
   rsrctab=b5||b4
   restab=b7||b6
   modtab=b9||b8
   imptab=bb||ba
   nrestab=bf||be||bd||bc
   o=o+1
   parse var output.o addr b0 b1 b2 b3 b4 b5 b6 b7'-'b8 b9 ba bb bc bd be bf .
   o=o+1
   cmovent=b1||b0
   align=b3||b2
   cres=b5||b4
   exetyp=b6
   oflags=b7
   retthks=b9||b8
   segref=bb||ba
   swaparea=bd||bc
   expver=bf||be

   say " "
   say 'Magic value                                 ' magic
   say 'Usage                                       ' usage
   say 'Entry table offset                          ' enttab
   say 'Next hExe                                   ' nextexe
   say 'Pointer to autodata                         ' pautodata
   say 'Pointer to file info                        ' pfileinfo
   say 'Flags                                       ' flags
   say 'Auto data segment                           ' segauto
   say 'Initial heap size                           ' heap
   say 'Initial stack size                          ' stack
   say 'Entry CS:IP                                 ' csip
   say 'Entry SS:SP                                 ' sssp
   say 'Segments                                    ' cseg
   say 'Module references                           ' cmod
   say 'Non-resident name table size                ' cbnrestab
   say 'Segment table offset                        ' segtab
   say 'Resource table offset                       ' rsrctab
   say 'Resident name table offset                  ' restab
   say 'Module reference table offset               ' modtab
   say 'Imported name table offset                  ' imptab
   say 'Non-resident name table offset              ' nrestab
   say 'Number of movable entries                   ' cmovent
   say 'Segment data allignment                     ' align
   say 'Number of resource segments                 ' cres
   say 'Operating system                            ' exetyp
   say 'Other flags                                 ' oflags
   say 'Return thunks offset                        ' retthks
   say 'Segment table reference bytes offset        ' segref
   say 'Minimum code swap size                      ' swaparea
   say 'Windows version number                      ' expver


end /* do */

if fobjects then do
   segs=getwords('#'exe't:1c',1)
   segtab=getwords('#'exe't:22',1)
   if segtab='' then signal error
   if segs='' then signal error
   off=0
   segs=x2d(segs)
   do i=1 to segs
      address df 'cmd output dw #'exe't:'segtab'+'off't L5'
      o=output.0-1
      parse var output.o . sect cbseg flags minalloc handle .
      if i=1 then say 'seg  sect cb   malc hndl sel  flags'
      f=x2c(flags)
      if bitand(f,'0001'x)='0001'x then flags=flags 'data'
      else flags=flags 'code'
      if bitand(f,'0008'x)='0008'x then flags=flags 'iter'
      if bitand(f,'0010'x)='0010'x then flags=flags 'move'
      if bitand(f,'0020'x)='0020'x then flags=flags 'pure'
      if bitand(f,'0040'x)='0040'x then flags=flags 'prel'
      if bitand(f,'0081'x)='0081'x then flags=flags 'rdo '
      if bitand(f,'0081'x)='0080'x then flags=flags 'exo '
      if bitand(f,'0100'x)='0100'x then flags=flags 'rel '
      if bitand(f,'0200'x)='0200'x then flags=flags 'dbg '
      if bitand(f,'0c00'x)='0c00'x then flags=flags '286 '
      if bitand(f,'1000'x)='1000'x then flags=flags 'disc'
      sel=c2x(bitor(x2c(handle),'0001'x))
      say right(d2x(i),4,'0') sect cbseg minalloc handle sel flags
      off=off+10
   end /* do */
   say ' '
end  /* Do */

if fenttab then do
   off=x2d(getwords('#'exe't:4',1))
   say 'Entry table:'
   say 'ord/ent  seg:off'
   do while off<>0
      address df 'cmd output dw #'exe't:'off't l3'
      o=output.0-1
      parse var output.o addr stord enord nextoff .
      stord=x2d(stord)
      enord=x2d(enord)
      off=off+6
      do ord=stord+1 to enord
         address df 'cmd output db #'exe't:'off't l5'
         o=output.0-1
         parse var output.o addr etype eflag eseg eoff1 eoff2 .
         eoff=eoff2||eoff1
         if etype='ff' then type='moveable'
         else if etype='01' then type='fixed'
         else if etype='00' then type='unused'
         else type='unknown type'
         if eseg='fe' then do
            eseg=' abs'
            type='absolute'
         end /* do */
         else eseg='00'eseg
         ef=x2c(eflag)
         if bitand(ef,'01'x)='01'x then type=type', exported'
         if bitand(ef,'02'x)='02'x then type=type', uses global data'
         if etype=ff then do
            wc=bitand(ef,'f8'x)
            wc=d2x(c2d(ef)/8)
            type=type', parm word count='wc
         end /* do */
         say '0x'right(d2x(ord),4,'0')':' eseg':'eoff 'type='etype 'flag='eflag type
         off=off+5
      end /* do */
      off=x2d(nextoff)
   end /* do */
   say ' '
end /* do */

if fnametab then do
   off=x2d(getwords('#'exe't:26',1))
   len=getbytes('#'exe't:'off't',1)
   say 'Resident Names Table:'
   say '   ord   name'
   do while len<>'00'
      address df 'cmd output da #'exe't:'off't+1 L0'len'+1'
      o=output.0-1
      parse var output.o addr name .
      ord=getwords('#'exe't:'off't+1+'len,1)
      say '  0x'ord name
      off=off+3+x2d(len)
      len=getbytes('#'exe't:'off't',1)
   end /* do */
end /* do */

if fimptab then do
   off=x2d(getwords('#'exe't:2a',1))
   off=off+1
   len=getbytes('#'exe't:'off't',1)
   say 'Imported Names Table:'
   do while len<>'00'
      address df 'cmd output da #'exe't:'off't+1 L0'len'+1'
      o=output.0-1
      parse var output.o addr name .
      say '  'name
      off=off+1+x2d(len)
      len=getbytes('#'exe't:'off't',1)
   end /* do */
end /* do */

if frestab then do
   x=getdwords('#'exe't:24',1)
   restab=right(x,4)
   nametab=left(x,4)
   if '#'restab<>'#'nametab then do
      say 'Resource table:'
      say '  type proc:addr noff nlen flag rid  hndl use'
      off=x2d(restab)+2
      address df 'cmd output dw #'exe't:'off't l4'
      o=output.0-1
      parse var output.o addr type nres poff pseg .
      do while type<>'0000'
         xt=x2c(type)
         if bitand(xt,'8000'x)='8000'x then do
            xt=bitand(xt,'7fff'x)
            if xt='0001'x then rtype='Cursor'
            else if xt='0002'x then rtype='Bitmap'
            else if xt='0003'x then rtype='Icon'
            else if xt='0004'x then rtype='Menu'
            else if xt='0005'x then rtype='Dialog'
            else if xt='0006'x then rtype='String'
            else if xt='0007'x then rtype='Font Dir'
            else if xt='0008'x then rtype='Font'
            else if xt='0009'x then rtype='Accelerator'
            else if xt='000a'x then rtype='RC Data'
            else if xt='000b'x then rtype='Group Cursor'
            else if xt='000c'x then rtype='Group Icon'
            else rtype='User resource'
         end /* do */
         off=off+8
         do x2d(nres)
            address df 'cmd output dw #'exe't:'off't l6'
            o=output.0-1
            parse var output.o addr rn_off rn_len rn_fl rn_id rn_hdl rn_us .
            off=off+12
            say '  'type pseg':'poff rn_off rn_len rn_fl rn_id rn_hdl rn_us rtype
         end /* do */
         address df 'cmd output dw #'exe't:'off't l4'
         o=output.0-1
         parse var output.o addr type nres poff pseg .
      end /* do */
   end /* do */
   say " "
end /* do */

return 0


helpmsg: procedure

say "Format Windows Loaded Module Table Header and Tables"
say ""
say "Syntax:"
say ""
say "  %WLM </options> <handle> </options>"
say ""
say "     where:    <handle> is the module handle (selector of loaded exehdr)"
say "               <options> are any combination of:"
say ""
say "                   ? - print help message"
say "                   E - format the Entry Table"
say "                   I - format the Imported Names Table"
say "                   L - select DLLs modules only"
say "                   N - format the Resident Names Table"
say "                   O - format the Object/Segment Table"
say "                   P - select DRV modules only"
say "                   R - format the Resource Table"
say "                   V - format the entire ExeHdr (without tables)"
say "                   X - select EXE modules only"
say " "
say "                   Options may be combined, with or without a "
say "                   leading /                                  "

return



wininit: procedure expose nothing

address df 'cmd output .p#'
o=output.0-1
if pos('*vdm',output.o)=0 then do
   say 'Current thread slot is not a VDM'
   return 0=1
end  /* Do */

vdm_slot=substr(output.o,2,4)
init_slot=value('DF_WWINVDM',,'OS2ENVIRONMENT')
if 'x'init_slot='x'vdm_slot then do
   /* just need to reset to vars that change in case we are under the kdb */
   dsel=value('DF_WKDSEL',,'OS2ENVIRONMENT')
   address df 'cmd output dw #'dsel':220  l8' /* make sure we use protmode addressing */
   o=output.0-1
   parse var output.o . tp hp . ht ct .
   otp=value('DF_WTOPPDB',tp,'OS2ENVIRONMENT')
   ohp=value('DF_WHEADPDB',hp,'OS2ENVIRONMENT')
   oht=value('DF_WHEADTDB',ht,'OS2ENVIRONMENT')
   oct=value('DF_WCURTDB',ct,'OS2ENVIRONMENT')   /* bug fix - was DF_WHCURTDB */
   if '#'otp<>'#'tp | '#'ohp<>'#'hp | '#'oht<>'#'ht | '#'oct<>'#'ct then,
      t=value('DF_WDEFTDB',ct,'OS2ENVIRONMENT')
   return 0=0
end /* do */
else do
   say 'Searching for WINDOWS kernel data segment'
   found=0=1
   do i = 1 to 8192
      sel=d2x((i*8)+7)
      if i//64 = 0 then do
         say 'Kernel data segment not found before' sel'. Continuing search'
      end /* do */
      address df 'cmd output dl' sel 'l1'
      o=output.0-1
      if word(output.o,2)='Code' then do
         x=getwords('#'sel':0',1)
         if x='f4cc' then do
            dsel=right(d2x(((i+3)*8)+7),4,'0')
            if translate(getwords('#'sel':30',1))=dsel then do
               say 'Windows Kernel Data Segment selector:' dsel
               x=value('DF_WKDSEL',dsel,'OS2ENVIRONMENT')
               x=value('DF_WWINVDM',vdm_slot,'OS2ENVIRONMENT')
               found=0=0
               leave
            end  /* Do */
         end  /* Do */
      end  /* Do */
   end /* do */

   if found then return 0=1

   say 'Initialising global variables'
   dseg='#'dsel':218' /* set starting address */
   doff=0             /* set current offset from this address */

   x=winsetvar('hGlobalHeap','w')
   x=winsetvar('pGlobalHeap','w')
   x=winsetvar('hExeHead','w')
   x=winsetvar('hExeSweep','w')
   x=winsetvar('TopPDB','w')
   x=winsetvar('headPDB','w')
   x=winsetvar('topsizePDB','w')
   x=winsetvar('headTDB','w')
   x=winsetvar('curTDB','w')
   x=winsetvar('loadTDB','w')
   x=winsetvar('lockTDB','w')
   x=winsetvar('SelTableLen','w')
   x=winsetvar('SelTableStart','d')
   x=winsetvar('hBmDPMI','d')
   x=winsetvar('winVer','w')
   x=winsetvar('fwinx','w')
   x=winsetvar('f8087','w')
   x=winsetvar('PHTcount','w')
   x=winsetvar('hGDI','w')
   x=winsetvar('hUser','w')
   x=winsetvar('hShell','w')
   x=winsetvar('flMDepth','w')
   x=winsetvar('wdefrip','w')
   x=winsetvar('num_tasks','b')
   x=winsetvar('InScheduler','b')
   x=winsetvar('graphics','b')
   /* spare byte */
   doff=doff+1
   x=winsetvar('fastfp','b')
   x=winsetvar('MaxCodeSwapArea','w')
   x=winsetvar('SelLowHeap','w')
   x=winsetvar('cpLowHeap','w')
   x=winsetvar('SelHighHeap','w')
   x=winsetvar('SelWoaPDB','w')
   x=winsetvar('sel_alias_array','w')
   x=winsetvar('temp_sel','w')
   x=winsetvar('dressed_for_success','D')
   x=winsetvar('InDos','d')
   x=winsetvar('pSftLink','d')
   x=winsetvar('lpWinSftLink','d')
   x=winsetvar('pFileTable','d')
   x=winsetvar('FileEntrySize','w')
   x=winsetvar('curDTA','d')
   x=winsetvar('cur_dos_PDB','w')
   x=winsetvar('Win_PDB','w')
   x=winsetvar('cur_drive_owner','w')
   x=winsetvar('fBreak','b')
   x=winsetvar('LastDriveSwapped','b')
   x=winsetvar('DOS_version','b')
   x=winsetvar('DOS_revision','b')
   x=winsetvar('fInt21','b')
   x=winsetvar('fNovell','b')
   x=winsetvar('fPadCode','b')
   x=winsetvar('CurDOSDrive','b')
   x=winsetvar('DOSDrives','b')

   t=value('DF_WCURTDB',,'OS2ENVIRONMENT')
   t=value('DF_WDEFTDB',t,'OS2ENVIRONMENT')

end /* do */

return 0=0

winsetvar: procedure expose dseg doff dsel
arg vname,type
type=translate(type)
if type='B' then do
   x=getbytes(dseg'+'doff't',1)
   doff=doff+1
end  /* Do */
else if type ='W' then do
   x=getwords(dseg'+'doff't',1)
   doff=doff+2
end  /* Do */
else if type ='D' then do
   x=getdwords(dseg'+'doff't',1)
   doff=doff+4
end  /* Do */
y=value('DF_W'vname,x,'OS2ENVIRONMENT')

return 0

getbytes: procedure
arg address,length
address df "cmd output DB" address "L1"
o=output.0-1
parse var output.o . stor .

do i=1 to length-1
   address df "cmd output DB "address"+"i"t L1"
   o=output.0-1
   stor=stor word(output.o,2)
end /* do */
return stor

getwords: procedure
arg address,length
address df "cmd output DW" address "L1"
o=output.0-1
parse var output.o . stor .

do i=1 to length-1
   address df "cmd output DW "address"+"i*2"t L1"
   o=output.0-1
   stor=stor word(output.o,2)
end /* do */
return stor

getdwords: procedure
arg address,length
address df "cmd output DD" address "L1"
o=output.0-1
parse var output.o . stor .

do i=1 to length-1
   address df "cmd output DD "address"+"i*4"t L1"
   o=output.0-1
   stor=stor word(output.o,2)
end /* do */
return stor



