/*rexx                                                               */
/*                                                                   */
/* (C) Copyright IBM Corp. 1993                                       */
/* (C) Copyright IBM Information Solutions 1993                       */
/*                                                                    */
/* locate the windows kernel data segment in the current slot */
/* kwseg <opt>                                                */
/* opt: D delete saved kernel data segment number             */
/* opt: L locate kernel data segment number (and save)        */


trace 'o'
parse upper arg req .
signal on halt name haltexit


if req='' then req='L'
if req='D' then do
   x=value('DF_WKDSEL','','OS2ENVIRONMENT')
   x=value('DF_WWINVDM','','OS2ENVIRONMENT')
   exit
end  /* Do */
if req='L' then do

   dsel=value('DF_WKDSEL',,'OS2ENVIRONMENT')
   if dsel <>'' then do
      say 'Windows Kernel Data Segment selector:' dsel
      exit
   end  /* Do */

   do i = 0 to 8192
      sel=d2x((i*8)+7)
      address df 'cmd output dl' sel 'l1'
      o=output.0-1
      if word(output.o,2)='Code' then do
         x=getwords('#'sel':0',1)
         if x='f4cc' then do
            dsel=right(d2x(((i+3)*8)+7),4,'0')
            if translate(getwords('#'sel':30',1))=dsel then do
               say 'Windows Kernel Data Segment selector:' dsel
               x=value('DF_WKDSEL',dsel,'OS2ENVIRONMENT')
               exit
            end  /* Do */
         end  /* Do */
      end  /* Do */
   end /* do */
end /* do */

haltexit: exit 0

getwords: procedure
arg address,length
address df "cmd output DW" address "L1"
o=output.0-1
parse var output.o . stor .

do i=1 to length-1
   address df "cmd output DW "address"+"i*2"t L1"
   o=output.0-1
   stor=stor word(output.o,2)
end /* do */
return stor

