/*rexx                                                               */
/*                                                                   */
/* (C) Copyright IBM Corp. 1993                                       */
/* (C) Copyright IBM Information Solutions 1993                       */
/*                                                                    */
/* Format VDM processes */
/* 9/5/97 fixed possible acidental exponential comparison */

signal on halt name haltexit

if IsVdm('Current Process is not a VDM') then exit 0

address df 'cmd output ln arena_head'
o=output.0-1
if left(output.o,1)='&' then do
   address df 'cmd output dw arena_head l2'
   o=output.0-1
   arena=word(output.o,2)
end /* do */
else do
   v86seg=getwords('_Segv86kernel',1)
   if datatype(v86seg,'x') then do
      say 'Unable to locate DOSKRNL - please load OS/2 kernel symbols'
      exit 0
   end /* do */
   v86seg='&'v86seg':0000'
   say ''
   say 'Warning: DOSKRNL symbols not loaded'
   say 'Assuming ARENA_HEAD at V86GROUP:24'
   say ''
   address df 'cmd output dw' v86seg'+24 l2'
   o=output.0-1
   arena=word(output.o,2)
end /* do */

curpdb=getwords('currentpdb',1)
if datatype(curpdb,'x') then curpdb=''


/* first scan the arena records looking for pdb owners */
pids.=''
pnames.=''
pid=0
quit=0=1

do until quit
   address df 'cmd output db &'arena':0 l10'
   o=output.0-1
   parse var output.o . b0 b1 b2 b3 b4 . . . . . . . . . . text .
   sig=b0
   own=b2||b1
   size=b4||b3
   name=substr(text,9,8)
   if sig='5a' then quit=0=0
   else if sig<>'4d' then quit=0=0
   ard=x2d(arena)
   if '#'own<>'#0000' & '#'own<>'#0008' then do
      ownd=x2d(own)
      if ard=ownd-1 then do
         pid=pid+1
         pids.pid=own
         pnames.pid=name
      end /* do */
   end /* do */
   arena=lower(right(d2x(ard+x2d(size)+1),4,'0'))
end /* do */

/* now format the pdb list in summary form */

say ' PDB   PPDB Usr-SS:SP lJFN   pJFN'

do i=1 to pid
   address df 'cmd output dw &'pids.i':16 L11'
   o=output.0-1
   jfnseg=word(output.o,2)
   o=o-1
   sp=word(output.o,6)
   ss=word(output.o,7)
   jfnlen=word(output.o,8)
   jfnoff=word(output.o,9)
   o=o-1
   ppdb=word(output.o,2)
   if 'x'curpdb='x'pids.i then f='*'
   else f=' '

   say f||pids.i' ' ppdb ss':'sp jfnlen jfnseg':'jfnoff pnames.i
end /* do */


haltexit: exit 0

getwords: procedure
arg address,length
address df "cmd output DW" address "L1"
o=output.0-1
parse var output.o . stor .

do i=1 to length-1
   address df "cmd output DW "address"+"i*2"t L1"
   o=output.0-1
   stor=stor word(output.o,2)
end /* do */
return stor

lower: procedure expose nothing
parse arg str
return translate(str,'abcdefghijklmnopqrstuvwxyz','ABCDEFGHIJKLMNOPQRSTUVWXYZ')

IsVDM: procedure
parse arg msgtxt

address df 'cmd output .p#'
o=output.0-1
if pos('*vdm',output.o)>0 then return 0=0
if msgtxt<>'' then say msgtxt
return 0=1
