/* IBM Confidential                                                  */
/* (C) Copyright IBM Corp. 1993                                       */
/* (C) Copyright IBM Information Solutions 1993                       */
/*                                                                    */
/*rexx                                                                */
/* Format Page Table Entries                                          */
/*                                                                    */
/* Syntax: DP  <options> <addr> <options>                             */
/*                                                                    */
/* where:      <addr>     is a valid DF address expression.           */
/*                                                                    */
/*             <options>  specify:                                    */
/*                                                                    */
/*                        /d directory entries only.                  */
/*                        /a Chain Option. Format related structures. */
/*                        /a all enties inclding unused entries.      */
/*                        /v verbose option, displays the raw entry   */
/*                           in addition to the formatted entry.      */
/*                        Ln number of enties in hex (including unused*/
/*                           entries. Default 10 (16 decimal)         */
/*                                                                    */
/*                        Options may be combined.                    */
/*                                                                    */
/* Change Log:                                                        */
/* 22/01/98 Version 1 created.                                        */

signal on halt name haltexit
trace 'o'
numeric digits 20
arg parms
addr = '%0'
debug=0=1
allpte=0=1
prtpde=0=0
prtpte=0=0
onlypdes=0=1
printed=0
chain=0=1
len='L10'

do while parms<>''
   parse var parms opt parms
   select
      when opt='?' then do
         call helpmsg
         exit
      end /* do */
      when opt='/A' then allpte=0=0
      when opt='/C' then chain=0=0
      when opt='/D' then do
         prtpte=0=1
         onlypdes=0=0
      end /* do */
      when opt='/V' then debug=0=0
      when left(opt,2)='/T' then trace (substr(opt,3))
      when left(opt,1)='L' then len=opt
   otherwise
   addr=opt
   end  /* select */
end /* do */

parse var len 'L' len .

len=x2d(len)

address df 'cmd output ?' addr
o=output.0-1
if left(word(output.o,1),1)='%' then addr=substr(word(output.o,1),2)
else if left(word(output.o,2),1)='%' then addr=substr(word(output.o,2),2)
else do
   say 'Error - invalid address'
   exit
end /* do */

addrd=x2d(addr)
paged=x2d(left(addr,5))


/* check for symbol overrides - in case we don't have the correct kernel symbols*/
pgdata=value('_PGDATA',,'OS2ENVIRONMENT')
if pgdata='' then pgdata='_pgdata'

pgshrdata=value('_PGSHRDATA',,'OS2ENVIRONMENT')
if pgshrdata='' then pgshrdata='_pgshrdata'

address df 'cmd output dd' pgdata 'l8'
o=output.0-1
parse var output.o . . base .
based=x2d(base)
if paged<based then do
   address df 'cmd output ?' pgshrdata
   o=output.0-1
   if word(output.o,1)<>'Expression' then do
      /* got a GSR */
      address df 'cmd output dd' pgshrdata 'l8'
      o=output.0-1
      parse var output.o . . base .
      based=x2d(base)
      if paged<based then do
        address df 'cmd output .p#'
        o=output.0-1
        parse var output.o . . . . . . . . ptda .
        address df 'cmd output dd %'ptda'+80 L8'
        o=output.0-1
      end /* do */
   end /* do */
   else do
     /* pre 3.0 - no GSR */
     address df 'cmd output .p#'
     o=output.0-1
     parse var output.o . . . . . . . . ptda .
     address df 'cmd output dd %'ptda'+80 L8'
     o=output.0-1
   end /* do */
end /* do */


parse var output.o . pcresident base vdmalias low_max .
o=o-1
parse var output.o . ppte ppde pcalloc pcpresent .
based=x2d(base)
off=right(addr,3)
paged=x2d(left(addr,5))-based
tabled=paged%1024

do i=1 to len
   addr=right(d2x(paged+based),5,'0') || off
   if prtpde then do
      call fmtpte tabled,addr,ppde,'*'
      prtpde=0=1
   end /* do */
   if prtpte then call fmtpte paged,addr,ppte,' '
   if onlypdes then paged=paged+1024
   else paged=paged+1
   ttbld=paged%1024
   if ttbld<>tabled then do
      prtpde=0=0
      tabled=ttbld
   end /* do */
end /* do */

haltexit: exit 0

fmtpte: procedure expose allpte printed debug chain
arg entry,addr,table,flag

address df 'cmd output dd %'table'+('entry't*4) l1'
o=output.0
o=o-1
parse var output.o . pte .
if pte='' then pte='00000000'
if '#'pte='#00000000' & allpte then return
frame=left(pte,5)
pflags=x2b(right(pte,3))
state=x2d(b2x(left(pflags,3)))
if state=0 then desc='pageable'
else if state=1 then desc='uvirt   '
else if state=2 then desc='resident'
else desc='UNKNOWN '
if debug then do
  if flag='*' then desc = desc 'pde='pte
  else desc = desc 'pte='pte
end
res=x2d(b2x(substr(pflags,4,2)))
if substr(pflags,6,1)=1 then dc='D'
else dc='c'
if substr(pflags,7,1)=1 then Au='A'
else Au='u'
if substr(pflags,8,1)=1 then CD='CD'
else CD='  '
if substr(pflags,9,1)=1 then WT='WT'
else WT='  '
if substr(pflags,10,1)=1 then Us='U'
else Us='s'
if substr(pflags,11,1)=1 then rW='W'
else rW='r'
line='%'lower(addr)||flag' '
if right(pflags,1)=1 then do
   line=line||frame'  frame='
   Pn='P'
end /* do */
else do
   line=line||'       vp id='
   Pn='n'
end /* do */
if printed=0 then say ' linaddr   frame   pteframe  state res Dc Au CD WT Us rW Pn state'
line=line||frame'  'state'    'res'  'Dc'  'Au'  'CD' 'WT' 'Us'  'rW'  'Pn'  'desc
say line
printed=(printed+1)//23
if chain then do
   if Pn='P' then do
      address df 'cmd output .mp' frame
      o=output.0-1
      parse var output.o . 'pVP='vpaddr . 'Frame='mpframe .
      if '#'mpframe='#'frame then do
         say ' pPF='output.o
         if vpaddr <> '' then do
            address df 'cmd output .mv %'vpaddr
            o=output.0-1
            parse var output.o . 'Hob='hob .
            say ' 'output.o
            address df 'cmd output .moc' hob
            do i=1 to output.0-1
               if output.i<>'' then say output.i
            end /* do */
         end /* do */
      end /* do */
   end /* do */
   else if frame <> '00000' then do
      vpid=frame
      address df 'cmd output .mv %'vpid
      o=output.0-1
      parse var output.o . 'Frame='frame .
      if frame<>'' then do
         address df 'cmd output .mp' frame
         o=output.0-1
         parse var output.o . 'Frame='mpframe .
         if '#'mpframe='#'frame then do
            say ' pPF='output.o
         end /* do */
      end /* do */
      address df 'cmd output .mv 'vpid
      o=output.0-1
      parse var output.o . 'Hob='hob .
      say ' 'output.o
      address df 'cmd output .moc' hob
      do i=1 to output.0-1
         if output.i<>'' then say output.i
      end /* do */
   end /* do */
   printed=0
   say ' '
   say ' '
end /* do */
return

helpmsg: procedure

   say "Format Page Table Entries                                         "
   say "                                                                  "
   say "Syntax: DP  <options> <addr> <options>                            "
   say "                                                                  "
   say "where:      <addr>     is a valid DF address expression.          "
   say "                                                                  "
   say "            <options>  specify:                                   "
   say " "
   say "                       /d directory entries only.                 "
   say "                       /c chain opton. Format related PG and VM structures. "
   say "                       /a all enties inclding unused entries.     "
   say "                       /v verbose option, displays the raw entry  "
   say "                          in addition to the formatted entry.     "
   say "                       Ln number of enties in hex (including unused"
   say "                          entries. Default 10 (16 decimal)        "
   say " "
   say "                       Options may be combined.                   "
   say " "
return

lower: procedure expose nothing
parse arg str
return translate(str,'abcdefghijklmnopqrstuvwxyz','ABCDEFGHIJKLMNOPQRSTUVWXYZ')
