/*rexx                                                               */
/*                                                                   */
/* (C) Copyright IBM Corp. 1998                                      */
/* (C) Copyright IBM Information Solutions 1998                      */
/*                                                                   */
/*                                                                   */
/*  Author: David Jaramillo                                          */
/*  Date: 22nd Feb 98                                                */
/*                                                                   */
/*  Change history:                                                  */
/*  1.0 created 2/22/98 DJ                                           */
/*                                                                   */
/*                                                                   */

signal on halt name haltexit
trace 'o'

numeric digits 12

arg procs

if words(procs)=0 then do
   say 'Extended .P - display all thead slots for selected processes'
   say ''
   say 'Syntax: %pp <proc_list>'
   say ''
   say 'where:'
   say '       <proc_list> is a list of one or more process names or pids.'
   say "                   In the case of ambiguity a name should be prefixed with a '"
   say ""
   say "Examples:"
   say "          %pp pmshell"
   say "                      selects all threads of all PMSHELL processes"
   say "          %pp 1d"
   say "                      selects all threads of pid 1d"
   say "          %pp *vdm pmshell"
   say "                      selects all VDMs and all PMSHELL threads"
end /* do */


parse var procs proc_parm procs
do while proc_parm<>''
proc_id=''
proc_name=''

if \datatype(proc_parm,'x') then do
	proc_name=strip(proc_parm,"b","'")
	proc_name=lower(proc_name)
end
else do
	proc_id=lower(proc_parm)
    proc_id=right(proc_id,4,'0')
end



address df 'cmd output .p#'
o=output.0-2

if word(text(output.o),1)="Slot" then do
   say 'Unable to determine current slot number'
   exit 8
end

say output.o
o=o+1
curslot=substr(text(output.o),2,4)

address df 'cmd output .p'

o=output.0

if proc_name <> '' then do 
	do i = 1 to o
      output.i=text(output.i)
		if word(output.i,1)="Slot" then
			iterate
		cols=words(output.i)
		if lower(word(output.i,cols))=proc_name then 
			say output.i
	end /* do */
end

if proc_id <> '' then do 
	do i = 1 to o
      output.i=text(output.i)
		if word(output.i,1)="Slot" then
			iterate
		if word(output.i,2)=proc_id then
			say output.i
	end /* do */
end
parse var procs proc_parm procs
end /* do */                                             
/* set slot to original slot */
address df 'cmd output .s' curslot
haltexit: 
exit 0

lower: procedure 
parse arg str
return translate(str,'abcdefghijklmnopqrstuvwxyz','ABCDEFGHIJKLMNOPQRSTUVWXYZ')


text: procedure
parse arg str
if left(str,1)<' ' then do
   p=lastpos('a'x,str)
   return substr(str,p+1)
end /* do */
else return str
