/*rexx                                                               */
/*                                                                   */
/* (C) Copyright IBM Corp. 1993                                       */
/* (C) Copyright IBM Information Solutions 1993                       */
/*                                                                    */
/* search for Windows memory owner */
/* 9/5/97 fixed possible acidental exponential comparison */

signal on halt name haltexit
numeric digits 18
trace 'o'
arg p1 p2 t .
if t='' then t='o'
trace(t)

if p1='?' then do
   call helpmsg
   exit 0
end /* do */

findentry=0=1
if p1='/X' then do
   findentry=0=0
   parm=p2
end /* do */
else ,
if p2='/X' then do
   findentry=0=0
   parm=p1
end /* do */
else parm=p1

if wininit() then exit 8
if parm='' then parm='#cs:ip'

parse var parm sel ':' moffset

if datatype(moffset,'x') then moffset=x2d(moffset)
modowner=0=1

linaddr=''
found=0=0
if left(sel,1)='#' then sel=substr(sel,2)
else if left(sel,1)='%' then linaddr=x2d(substr(sel,2))
else if left(sel,1)='&' then do
   sel=substr(sel,2)
   linaddr=x2d(sel'0')+x2d(off)
end /* do */
else parm='#'parm

if linaddr<>'' then do
found=0=1
   say 'Searching LDT for 16-bit segment mapping %'d2x(linaddr)
   do i = 1 to 8192
      sel=d2x((i*8)+7)
      if i//64 = 0 then do
         say 'Selector not found before' sel'. Continuing search'
      end /* do */
      address df 'cmd output dl' sel 'l1'
      o=output.0-1
      parse var output.o . 'Bas=' base . 'Lim=' lim .
      if (datatype(base,'x') & datatype(lim,'x')) then do
         dbase=x2d(base)
         dlim=x2d(lim)
         if (dlim < 65536 & linaddr>=dbase & linaddr<=dbase+dlim) then do
            found=0=0
            say 'Selector' sel 'found.'
            leave
         end /* do */
      end /* do */
   end /* do */
end /* do */

if found then do
   say 'Unable to deterine owner of address' parm
   exit 8
end /* do */

seltab=value('DF_WSELTABLESTART',,'OS2ENVIRONMENT')
hsel=value('DF_WHGLOBALHEAP',,'OS2ENVIRONMENT')
selinfo='#'hsel':('seltab'+(('sel' and fff8)/2)) l1'

address df 'cmd output dd' selinfo
o=output.0-1
aroff=word(output.o,2)
if '#'aroff='#00000000' then do
   say 'Selector' sel 'not found in global heap selector table'
   say 'Unable to determine owner of' parm
   exit 4
end /* do */

pdbowner.=''
tdbowner.=''
nexttdb=value('DF_WHEADTDB',,'OS2ENVIRONMENT')
do while nexttdb<>'0000'
   x=getwords('#'nexttdb':60',1)
   address df 'cmd output da #'nexttdb':f2 l9'
   o=output.0-1
   pdbowner.x=word(output.o,2)
   tdbowner.nexttdb=word(output.o,2)
   nexttdb=getwords('#'nexttdb':0',1)
end /* do */

address df 'cmd output dd #'hsel':'aroff 'l8'
o1=output.0-2
o2=output.0-1
ar1=output.o1
ar2=output.o2
parse var ar1 . next prev addr size .
parse var ar2 . ho fl lrup lrun .
own=left(ho,4)
hndl=right(ho,4)
scnt=left(fl,2)
flgs=substr(fl,3,2)
lock=substr(fl,5,2)
cnt=right(fl,2)
ownerid=''
select
   when own='ffff' then ownerid='Sentinel'
   when own='fff8' then ownerid='Temporary'
   when own='fffc' then ownerid='Master'
   when own='fffb' then ownerid='Unallocated'
   when own='fffa' then ownerid='Phantom'
   when own='fff9' then ownerid='Wraith'
otherwise
   x=getwords('#'own':0',1)
   if x'#'='454e#' then do
      finfo=getwords('#'own':a',1)
      address df 'cmd output da #'own':'finfo'+8'
      o=output.0-1
      name=word(output.o,2)
      p=lastpos('\',name)
      ownerid=substr(name,p+1)
      /*
      sname=substr(name,p+1)
      parse upper var sname ownerid '.' ext
      */
      parse var ownerid module '.' ext
      ownerid='Mod' ownerid
      modowner=0=0
   end  /* Do */
   else if pdbowner.own<>'' then do
      ownerid='PDB' pdbowner.own
   end  /* Do */
   else if tdbowner.own<>'' then do
      ownerid='TDB' tdbowner.own
   end /* do */
   else ownerid='UNKNOWN'
end  /* select */

say 'hndl    va       cb    hsel next     prev     own  sc fl lk ct lrup     lrun'
say hndl addr size hsel next prev own scnt flgs lock cnt lrup lrun ownerid

if (modowner & findentry) then do
   /* lookup the segment number in the segment table */
   tfl=getwords('#'own':36',1)
   flags=left(tfl,2)
   type=right(tfl,2)
   select
      when type='00' then type='Any NE '
      when type='01' then type='Default'
      when type='02' then type='Windows'
      when type='03' then type='DOS 4.x'
      when type='04' then type='Win386 '
   otherwise
   type='UNKNOWN'
   end  /* select */

   hExe=right(own,4,'0')
   say ' '
   say 'hExe='hExe 'type='type 'flags='flags name
   segno=''
   segs=getwords('#'own':1c',1)
   segtab=getwords('#'own':22',1)
   off=0
   segs=x2d(segs)
   do i=1 to segs
      address df 'cmd output dw #'own':'segtab'+'off't L5'
      o=output.0-1
      parse var output.o . sect cbseg flags minalloc handle .
      segsel=c2x(bitor(x2c(handle),'0001'x))
      if x2d(sel)=x2d(segsel) then do
         say 'seg  sect cb   malc hndl sel  flags'
         f=x2c(flags)
         if bitand(f,'0001'x)='0001'x then flags=flags 'data'
         else flags=flags 'code'
         if bitand(f,'0008'x)='0008'x then flags=flags 'iter'
         if bitand(f,'0010'x)='0010'x then flags=flags 'move'
         if bitand(f,'0020'x)='0020'x then flags=flags 'pure'
         if bitand(f,'0040'x)='0040'x then flags=flags 'prel'
         if bitand(f,'0081'x)='0081'x then flags=flags 'rdo '
         if bitand(f,'0081'x)='0080'x then flags=flags 'exo '
         if bitand(f,'0100'x)='0100'x then flags=flags 'rel '
         if bitand(f,'0200'x)='0200'x then flags=flags 'dbg '
         if bitand(f,'0c00'x)='0c00'x then flags=flags '286 '
         if bitand(f,'1000'x)='1000'x then flags=flags 'disc'
         say right(d2x(i),4,'0') sect cbseg minalloc handle segsel flags
         segno=i
         leave
      end /* do */
      off=off+10
   end /* do */
   if segno='' then do
      say 'Unable to locate selector within segment table for' module
      exit 0
   end /* do */

   /* now locate the matching entry address */
   say ' '
   say 'Searching entry table ...'
   foundord=''
   off=x2d(getwords('#'own':4',1))
   do while off<>0 & foundord=''
      address df 'cmd output dw #'own':'off't l3'
      o=output.0-1
      parse var output.o addr stord enord nextoff .
      stord=x2d(stord)
      enord=x2d(enord)
      off=off+6
      do ord=stord+1 to enord
         address df 'cmd output db #'own':'off't l5'
         o=output.0-1
         parse var output.o addr etype eflag eseg eoff1 eoff2 .
         eoff=eoff2||eoff1
         if x2d(eseg)=segno & x2d(eoff)=moffset then do
            if etype='ff' then type='moveable'
            else if etype='01' then type='fixed'
            else if etype='00' then type='unused'
            else type='unknown type'
            if eseg='fe' then do
               eseg=' abs'
               type='absolute'
            end /* do */
            else eseg='00'eseg
            ef=x2c(eflag)
            if bitand(ef,'01'x)='01'x then type=type', exported'
            if bitand(ef,'02'x)='02'x then type=type', uses global data'
            if etype=ff then do
               wc=bitand(ef,'f8'x)
               wc=d2x(c2d(ef)/8)
               type=type', parm word count='wc
            end /* do */
            say 'ord/ent  seg:off'
            say '0x'right(d2x(ord),4,'0')':' eseg':'eoff 'type='etype 'flag='eflag type
            foundord=ord
            leave ord
         end /* do */
         off=off+5
      end /* do */
      off=x2d(nextoff)
   end /* do */
   if foundord='' then do
      say 'Unable to locate entry point in' module
      exit 0
   end /* do */
   /* now look up ordinal in xref */
   if module='OS2K386' then module='KERNEL'

   call winitord

   name=ordinals.module.foundord
   say ' '
   if name='' then say module'.'ord'(0x'd2x(ord)') not found'
   else say module'.'ord'(0x'd2x(ord)') ==>' name

end /* do */

haltexit: exit 0

error: say 'Unable to process command'
exit 8

helpmsg: procedure

say "Locate the owner of a Windows Allocation"
say " "
say "Syntax: %WM <options> <address>|<Selector> <options>"
say ""
say "Where:"
say ""
say "           <address>  specifies an address expression"
say "           <selector> specifies an selector number"
say "           <options>  specify /X for an extended search"
say ""
say "    The simple search locates the Arena record that encompasses the"
say "    suppied address. If this address or selector is omitted then"
say "    #cs:ip is assumed."
say "    The extended search will do the following if the object is part"
say "    of a load moduleand a full selector:offset address has been"
say "    supplied:"
say "        locate the module's segment"
say "        locate the module's segment"
say "        locate the matching entry point ordinal in the Entry Table"
say "        look-up the Entry Name that corresponds to the ordinal"


return


wininit: procedure expose nothing

address df 'cmd output .p#'
o=output.0-1
if pos('*vdm',output.o)=0 then do
   say 'Current thread slot is not a VDM'
   return 0=1
end  /* Do */

vdm_slot=substr(output.o,2,4)
init_slot=value('DF_WWINVDM',,'OS2ENVIRONMENT')
if 'x'init_slot='x'vdm_slot then do
   /* just need to reset to vars that change in case we are under the kdb */
   dsel=value('DF_WKDSEL',,'OS2ENVIRONMENT')
   address df 'cmd output dw #'dsel':220  l8' /* make sure we use protmode addressing */
   o=output.0-1
   parse var output.o . tp hp . ht ct .
   otp=value('DF_WTOPPDB',tp,'OS2ENVIRONMENT')
   ohp=value('DF_WHEADPDB',hp,'OS2ENVIRONMENT')
   oht=value('DF_WHEADTDB',ht,'OS2ENVIRONMENT')
   oct=value('DF_WCURTDB',ct,'OS2ENVIRONMENT')   /* bug fix - was DF_WHCURTDB */
   if '#'otp<>'#'tp | '#'ohp<>'#'hp | '#'oht<>'#'ht | '#'oct<>'#'ct then,
      t=value('DF_WDEFTDB',ct,'OS2ENVIRONMENT')
   return 0=0
end /* do */
else do
   say 'Searching for WINDOWS kernel data segment'
   found=0=1
   do i = 1 to 8192
      sel=d2x((i*8)+7)
      if i//64 = 0 then do
         say 'Kernel data segment not found before' sel'. Continuing search'
      end /* do */
      address df 'cmd output dl' sel 'l1'
      o=output.0-1
      if word(output.o,2)='Code' then do
         x=getwords('#'sel':0',1)
         if x='f4cc' then do
            dsel=right(d2x(((i+3)*8)+7),4,'0')
            if translate(getwords('#'sel':30',1))=dsel then do
               say 'Windows Kernel Data Segment selector:' dsel
               x=value('DF_WKDSEL',dsel,'OS2ENVIRONMENT')
               x=value('DF_WWINVDM',vdm_slot,'OS2ENVIRONMENT')
               found=0=0
               leave
            end  /* Do */
         end  /* Do */
      end  /* Do */
   end /* do */

   if found then return 0=1

   say 'Initialising global variables'
   dseg='#'dsel':218' /* set starting address */
   doff=0             /* set current offset from this address */

   x=winsetvar('hGlobalHeap','w')
   x=winsetvar('pGlobalHeap','w')
   x=winsetvar('hExeHead','w')
   x=winsetvar('hExeSweep','w')
   x=winsetvar('TopPDB','w')
   x=winsetvar('headPDB','w')
   x=winsetvar('topsizePDB','w')
   x=winsetvar('headTDB','w')
   x=winsetvar('curTDB','w')
   x=winsetvar('loadTDB','w')
   x=winsetvar('lockTDB','w')
   x=winsetvar('SelTableLen','w')
   x=winsetvar('SelTableStart','d')
   x=winsetvar('hBmDPMI','d')
   x=winsetvar('winVer','w')
   x=winsetvar('fwinx','w')
   x=winsetvar('f8087','w')
   x=winsetvar('PHTcount','w')
   x=winsetvar('hGDI','w')
   x=winsetvar('hUser','w')
   x=winsetvar('hShell','w')
   x=winsetvar('flMDepth','w')
   x=winsetvar('wdefrip','w')
   x=winsetvar('num_tasks','b')
   x=winsetvar('InScheduler','b')
   x=winsetvar('graphics','b')
   /* spare byte */
   doff=doff+1
   x=winsetvar('fastfp','b')
   x=winsetvar('MaxCodeSwapArea','w')
   x=winsetvar('SelLowHeap','w')
   x=winsetvar('cpLowHeap','w')
   x=winsetvar('SelHighHeap','w')
   x=winsetvar('SelWoaPDB','w')
   x=winsetvar('sel_alias_array','w')
   x=winsetvar('temp_sel','w')
   x=winsetvar('dressed_for_success','D')
   x=winsetvar('InDos','d')
   x=winsetvar('pSftLink','d')
   x=winsetvar('lpWinSftLink','d')
   x=winsetvar('pFileTable','d')
   x=winsetvar('FileEntrySize','w')
   x=winsetvar('curDTA','d')
   x=winsetvar('cur_dos_PDB','w')
   x=winsetvar('Win_PDB','w')
   x=winsetvar('cur_drive_owner','w')
   x=winsetvar('fBreak','b')
   x=winsetvar('LastDriveSwapped','b')
   x=winsetvar('DOS_version','b')
   x=winsetvar('DOS_revision','b')
   x=winsetvar('fInt21','b')
   x=winsetvar('fNovell','b')
   x=winsetvar('fPadCode','b')
   x=winsetvar('CurDOSDrive','b')
   x=winsetvar('DOSDrives','b')

   t=value('DF_WCURTDB',,'OS2ENVIRONMENT')
   t=value('DF_WDEFTDB',t,'OS2ENVIRONMENT')

end /* do */

return 0=0

winsetvar: procedure expose dseg doff dsel
arg vname,type
type=translate(type)
if type='B' then do
   x=getbytes(dseg'+'doff't',1)
   doff=doff+1
end  /* Do */
else if type ='W' then do
   x=getwords(dseg'+'doff't',1)
   doff=doff+2
end  /* Do */
else if type ='D' then do
   x=getdwords(dseg'+'doff't',1)
   doff=doff+4
end  /* Do */
y=value('DF_W'vname,x,'OS2ENVIRONMENT')

return 0

getbytes: procedure
arg address,length
address df "cmd output DB" address "L1"
o=output.0-1
parse var output.o . stor .

do i=1 to length-1
   address df "cmd output DB "address"+"i"t L1"
   o=output.0-1
   stor=stor word(output.o,2)
end /* do */
return stor

getwords: procedure
arg address,length
address df "cmd output DW" address "L1"
o=output.0-1
parse var output.o . stor .

do i=1 to length-1
   address df "cmd output DW "address"+"i*2"t L1"
   o=output.0-1
   stor=stor word(output.o,2)
end /* do */
return stor

getdwords: procedure
arg address,length
address df "cmd output DD" address "L1"
o=output.0-1
parse var output.o . stor .

do i=1 to length-1
   address df "cmd output DD "address"+"i*4"t L1"
   o=output.0-1
   stor=stor word(output.o,2)
end /* do */
return stor


winitord: procedure expose ordinals.
ordinals.=''

ordinals.KERNEL.1='FATALEXIT'
ordinals.KERNEL.3='GETVERSION'
ordinals.KERNEL.4='LOCALINIT'
ordinals.KERNEL.5='LOCALALLOC'
ordinals.KERNEL.6='LOCALREALLOC'
ordinals.KERNEL.7='LOCALFREE'
ordinals.KERNEL.8='LOCALLOCK'
ordinals.KERNEL.9='LOCALUNLOCK'
ordinals.KERNEL.10='LOCALSIZE'
ordinals.KERNEL.11='LOCALHANDLE'
ordinals.KERNEL.12='LOCALFLAGS'
ordinals.KERNEL.13='LOCALCOMPACT'
ordinals.KERNEL.15='GLOBALALLOC'
ordinals.KERNEL.16='GLOBALREALLOC'
ordinals.KERNEL.17='GLOBALFREE'
ordinals.KERNEL.18='GLOBALLOCK'
ordinals.KERNEL.19='GLOBALUNLOCK'
ordinals.KERNEL.20='GLOBALSIZE'
ordinals.KERNEL.21='GLOBALHANDLE'
ordinals.KERNEL.22='GLOBALFLAGS'
ordinals.KERNEL.23='LOCKSEGMENT'
ordinals.KERNEL.24='UNLOCKSEGMENT'
ordinals.KERNEL.25='GLOBALCOMPACT'
ordinals.KERNEL.29='YIELD'
ordinals.KERNEL.30='WAITEVENT'
ordinals.KERNEL.36='GETCURRENTTASK'
ordinals.KERNEL.37='GETCURRENTPDB'
ordinals.KERNEL.45='LOADMODULE'
ordinals.KERNEL.46='FREEMODULE'
ordinals.KERNEL.47='GETMODULEHANDLE'
ordinals.KERNEL.48='GETMODULEUSAGE'
ordinals.KERNEL.49='GETMODULEFILENAME'
ordinals.KERNEL.50='GETPROCADDRESS'
ordinals.KERNEL.51='MAKEPROCINSTANCE'
ordinals.KERNEL.52='FREEPROCINSTANCE'
ordinals.KERNEL.54='GETINSTANCEDATA'
ordinals.KERNEL.55='CATCH'
ordinals.KERNEL.56='THROW'
ordinals.KERNEL.57='GETPROFILEINT'
ordinals.KERNEL.58='GETPROFILESTRING'
ordinals.KERNEL.59='WRITEPROFILESTRING'
ordinals.KERNEL.60='FINDRESOURCE'
ordinals.KERNEL.61='LOADRESOURCE'
ordinals.KERNEL.62='LOCKRESOURCE'
ordinals.KERNEL.63='FREERESOURCE'
ordinals.KERNEL.64='ACCESSRESOURCE'
ordinals.KERNEL.65='SIZEOFRESOURCE'
ordinals.KERNEL.66='ALLOCRESOURCE'
ordinals.KERNEL.67='SETRESOURCEHANDLER'
ordinals.KERNEL.68='INITATOMTABLE'
ordinals.KERNEL.69='FINDATOM'
ordinals.KERNEL.70='ADDATOM'
ordinals.KERNEL.71='DELETEATOM'
ordinals.KERNEL.72='GETATOMNAME'
ordinals.KERNEL.73='GETATOMHANDLE'
ordinals.KERNEL.74='OPENFILE'
ordinals.KERNEL.77='RESERVED1'
ordinals.KERNEL.78='RESERVED2'
ordinals.KERNEL.79='RESERVED3'
ordinals.KERNEL.80='RESERVED4'
ordinals.KERNEL.81='_LCLOSE'
ordinals.KERNEL.82='_LREAD'
ordinals.KERNEL.83='_LCREAT'
ordinals.KERNEL.84='_LLSEEK'
ordinals.KERNEL.85='_LOPEN'
ordinals.KERNEL.86='_LWRITE'
ordinals.KERNEL.87='RESERVED5'
ordinals.KERNEL.88='LSTRCPY'
ordinals.KERNEL.89='LSTRCAT'
ordinals.KERNEL.90='LSTRLEN'
ordinals.KERNEL.91='INITTASK'
ordinals.KERNEL.92='GETTEMPDRIVE'
ordinals.KERNEL.93='GETCODEHANDLE'
ordinals.KERNEL.94='DEFINEHANDLETABLE'
ordinals.KERNEL.95='LOADLIBRARY'
ordinals.KERNEL.96='FREELIBRARY'
ordinals.KERNEL.97='GETTEMPFILENAME'
ordinals.KERNEL.100='VALIDATECODESEGMENTS'
ordinals.KERNEL.102='DOS3CALL'
ordinals.KERNEL.103='NETBIOSCALL'
ordinals.KERNEL.104='GETCODEINFO'
ordinals.KERNEL.106='SETSWAPAREASIZE'
ordinals.KERNEL.107='SETERRORMODE'
ordinals.KERNEL.108='SWITCHSTACKTO'
ordinals.KERNEL.109='SWITCHSTACKBACK'
ordinals.KERNEL.110='PATCHCODEHANDLE'
ordinals.KERNEL.111='GLOBALWIRE'
ordinals.KERNEL.112='GLOBALUNWIRE'
ordinals.KERNEL.113='__AHSHIFT'
ordinals.KERNEL.114='__AHINCR'
ordinals.KERNEL.115='OUTPUTDEBUGSTRING'
ordinals.KERNEL.121='LOCALSHRINK'
ordinals.KERNEL.127='GETPRIVATEPROFILEINT'
ordinals.KERNEL.128='GETPRIVATEPROFILESTRING'
ordinals.KERNEL.129='WRITEPRIVATEPROFILESTRING'
ordinals.KERNEL.131='GETDOSENVIRONMENT'
ordinals.KERNEL.132='GETWINFLAGS'
ordinals.KERNEL.134='GETWINDOWSDIRECTORY'
ordinals.KERNEL.135='GETSYSTEMDIRECTORY'
ordinals.KERNEL.136='GETDRIVETYPE'
ordinals.KERNEL.137='FATALAPPEXIT'
ordinals.KERNEL.150='DIRECTEDYIELD'
ordinals.KERNEL.152='GETNUMTASKS'
ordinals.KERNEL.154='GLOBALNOTIFY'
ordinals.KERNEL.156='LIMITEMSPAGES'
ordinals.KERNEL.163='GLOBALLRUOLDEST'
ordinals.KERNEL.164='GLOBALLRUNEWEST'
ordinals.KERNEL.166='WINEXEC'
ordinals.KERNEL.169='GETFREESPACE'
ordinals.KERNEL.170='ALLOCCSTODSALIAS'
ordinals.KERNEL.171='ALLOCDSTOCSALIAS'
ordinals.KERNEL.172='ALLOCALIAS'
ordinals.KERNEL.173='__ROMBIOS'
ordinals.KERNEL.174='__A000h'
ordinals.KERNEL.175='ALLOCSELECTOR'
ordinals.KERNEL.176='FREESELECTOR'
ordinals.KERNEL.177='PRESTOCHANGOSELECTOR'
ordinals.KERNEL.178='__WINFLAGS'
ordinals.KERNEL.179='__D000h'
ordinals.KERNEL.180='LONGPTRADD'
ordinals.KERNEL.181='__B000h'
ordinals.KERNEL.182='__B800h'
ordinals.KERNEL.183='__0000h'
ordinals.KERNEL.184='GLOBALDOSALLOC'
ordinals.KERNEL.185='GLOBALDOSFREE'
ordinals.KERNEL.186='GETSELECTORBASE'
ordinals.KERNEL.187='SETSELECTORBASE'
ordinals.KERNEL.188='GETSELECTORLIMIT'
ordinals.KERNEL.189='SETSELECTORLIMIT'
ordinals.KERNEL.190='__E000h'
ordinals.KERNEL.191='GLOBALPAGELOCK'
ordinals.KERNEL.192='GLOBALPAGEUNLOCK'
ordinals.KERNEL.193='__0040h'
ordinals.KERNEL.194='__F000h'
ordinals.KERNEL.195='__C000h'
ordinals.KERNEL.196='SELECTORACCESSRIGHTS'
ordinals.KERNEL.197='GLOBALFIX'
ordinals.KERNEL.198='GLOBALUNFIX'
ordinals.KERNEL.199='SETHANDLECOUNT'
ordinals.KERNEL.200='VALIDATEFREESPACES'
ordinals.KERNEL.203='DEBUGBREAK'
ordinals.KERNEL.204='SWAPRECORDING'
ordinals.KERNEL.205='CVWBREAK'
ordinals.KERNEL.207='ISDBCSLEADBYTE'
ordinals.KERNEL.310='LOCALHANDLEDELTA'
ordinals.KERNEL.316='GETFREEMEMINFO'
ordinals.KERNEL.320='ISTASK'
ordinals.KERNEL.324='LOGERROR'
ordinals.KERNEL.325='LOGPARAMERROR'
ordinals.KERNEL.334='ISBADREADPTR'
ordinals.KERNEL.335='ISBADWRITEPTR'
ordinals.KERNEL.336='ISBADCODEPTR'
ordinals.KERNEL.337='ISBADSTRINGPTR'
ordinals.KERNEL.339='DIAGQUERY'
ordinals.KERNEL.340='DIAGOUTPUT'
ordinals.KERNEL.343='REGISTERWINOLDAPHOOK'
ordinals.KERNEL.344='GETWINOLDAPHOOKS'
ordinals.KERNEL.346='ISBADHUGEREADPTR'
ordinals.KERNEL.347='ISBADHUGEWRITEPTR'
ordinals.KERNEL.348='HMEMCPY'
ordinals.KERNEL.349='_HREAD'
ordinals.KERNEL.350='_HWRITE'
ordinals.KERNEL.353='LSTRCPYN'
ordinals.KERNEL.355='GETWINDEBUGINFO'
ordinals.KERNEL.356='SETWINDEBUGINFO'
ordinals.GDI.1='SETBKCOLOR'
ordinals.GDI.2='SETBKMODE'
ordinals.GDI.3='SETMAPMODE'
ordinals.GDI.4='SETROP2'
ordinals.GDI.6='SETPOLYFILLMODE'
ordinals.GDI.7='SETSTRETCHBLTMODE'
ordinals.GDI.8='SETTEXTCHARACTEREXTRA'
ordinals.GDI.9='SETTEXTCOLOR'
ordinals.GDI.10='SETTEXTJUSTIFICATION'
ordinals.GDI.11='SETWINDOWORG'
ordinals.GDI.12='SETWINDOWEXT'
ordinals.GDI.13='SETVIEWPORTORG'
ordinals.GDI.14='SETVIEWPORTEXT'
ordinals.GDI.15='OFFSETWINDOWORG'
ordinals.GDI.16='SCALEWINDOWEXT'
ordinals.GDI.17='OFFSETVIEWPORTORG'
ordinals.GDI.18='SCALEVIEWPORTEXT'
ordinals.GDI.19='LINETO'
ordinals.GDI.20='MOVETO'
ordinals.GDI.21='EXCLUDECLIPRECT'
ordinals.GDI.22='INTERSECTCLIPRECT'
ordinals.GDI.23='ARC'
ordinals.GDI.24='ELLIPSE'
ordinals.GDI.25='FLOODFILL'
ordinals.GDI.26='PIE'
ordinals.GDI.27='RECTANGLE'
ordinals.GDI.28='ROUNDRECT'
ordinals.GDI.29='PATBLT'
ordinals.GDI.30='SAVEDC'
ordinals.GDI.31='SETPIXEL'
ordinals.GDI.32='OFFSETCLIPRGN'
ordinals.GDI.33='TEXTOUT'
ordinals.GDI.34='BITBLT'
ordinals.GDI.35='STRETCHBLT'
ordinals.GDI.36='POLYGON'
ordinals.GDI.37='POLYLINE'
ordinals.GDI.38='ESCAPE'
ordinals.GDI.39='RESTOREDC'
ordinals.GDI.40='FILLRGN'
ordinals.GDI.41='FRAMERGN'
ordinals.GDI.42='INVERTRGN'
ordinals.GDI.43='PAINTRGN'
ordinals.GDI.44='SELECTCLIPRGN'
ordinals.GDI.45='SELECTOBJECT'
ordinals.GDI.47='COMBINERGN'
ordinals.GDI.48='CREATEBITMAP'
ordinals.GDI.49='CREATEBITMAPINDIRECT'
ordinals.GDI.50='CREATEBRUSHINDIRECT'
ordinals.GDI.51='CREATECOMPATIBLEBITMAP'
ordinals.GDI.52='CREATECOMPATIBLEDC'
ordinals.GDI.53='CREATEDC'
ordinals.GDI.54='CREATEELLIPTICRGN'
ordinals.GDI.55='CREATEELLIPTICRGNINDIRECT'
ordinals.GDI.56='CREATEFONT'
ordinals.GDI.57='CREATEFONTINDIRECT'
ordinals.GDI.58='CREATEHATCHBRUSH'
ordinals.GDI.60='CREATEPATTERNBRUSH'
ordinals.GDI.61='CREATEPEN'
ordinals.GDI.62='CREATEPENINDIRECT'
ordinals.GDI.63='CREATEPOLYGONRGN'
ordinals.GDI.64='CREATERECTRGN'
ordinals.GDI.65='CREATERECTRGNINDIRECT'
ordinals.GDI.66='CREATESOLIDBRUSH'
ordinals.GDI.67='DPTOLP'
ordinals.GDI.68='DELETEDC'
ordinals.GDI.69='DELETEOBJECT'
ordinals.GDI.70='ENUMFONTS'
ordinals.GDI.71='ENUMOBJECTS'
ordinals.GDI.72='EQUALRGN'
ordinals.GDI.74='GETBITMAPBITS'
ordinals.GDI.75='GETBKCOLOR'
ordinals.GDI.76='GETBKMODE'
ordinals.GDI.77='GETCLIPBOX'
ordinals.GDI.78='GETCURRENTPOSITION'
ordinals.GDI.79='GETDCORG'
ordinals.GDI.80='GETDEVICECAPS'
ordinals.GDI.81='GETMAPMODE'
ordinals.GDI.82='GETOBJECT'
ordinals.GDI.83='GETPIXEL'
ordinals.GDI.84='GETPOLYFILLMODE'
ordinals.GDI.85='GETROP2'
ordinals.GDI.87='GETSTOCKOBJECT'
ordinals.GDI.88='GETSTRETCHBLTMODE'
ordinals.GDI.89='GETTEXTCHARACTEREXTRA'
ordinals.GDI.90='GETTEXTCOLOR'
ordinals.GDI.91='GETTEXTEXTENT'
ordinals.GDI.92='GETTEXTFACE'
ordinals.GDI.93='GETTEXTMETRICS'
ordinals.GDI.94='GETVIEWPORTEXT'
ordinals.GDI.95='GETVIEWPORTORG'
ordinals.GDI.96='GETWINDOWEXT'
ordinals.GDI.97='GETWINDOWORG'
ordinals.GDI.99='LPTODP'
ordinals.GDI.100='LINEDDA'
ordinals.GDI.101='OFFSETRGN'
ordinals.GDI.103='PTVISIBLE'
ordinals.GDI.104='RECTVISIBLE'
ordinals.GDI.106='SETBITMAPBITS'
ordinals.GDI.119='ADDFONTRESOURCE'
ordinals.GDI.123='PLAYMETAFILE'
ordinals.GDI.124='GETMETAFILE'
ordinals.GDI.125='CREATEMETAFILE'
ordinals.GDI.126='CLOSEMETAFILE'
ordinals.GDI.127='DELETEMETAFILE'
ordinals.GDI.128='MULDIV'
ordinals.GDI.132='SETENVIRONMENT'
ordinals.GDI.133='GETENVIRONMENT'
ordinals.GDI.134='GETRGNBOX'
ordinals.GDI.136='REMOVEFONTRESOURCE'
ordinals.GDI.148='SETBRUSHORG'
ordinals.GDI.149='GETBRUSHORG'
ordinals.GDI.150='UNREALIZEOBJECT'
ordinals.GDI.151='COPYMETAFILE'
ordinals.GDI.153='CREATEIC'
ordinals.GDI.154='GETNEARESTCOLOR'
ordinals.GDI.155='QUERYABORT'
ordinals.GDI.156='CREATEDISCARDABLEBITMAP'
ordinals.GDI.159='GETMETAFILEBITS'
ordinals.GDI.160='SETMETAFILEBITS'
ordinals.GDI.161='PTINREGION'
ordinals.GDI.162='GETBITMAPDIMENSION'
ordinals.GDI.163='SETBITMAPDIMENSION'
ordinals.GDI.172='SETRECTRGN'
ordinals.GDI.175='ENUMMETAFILE'
ordinals.GDI.176='PLAYMETAFILERECORD'
ordinals.GDI.181='RECTINREGION'
ordinals.GDI.193='SETBOUNDSRECT'
ordinals.GDI.194='GETBOUNDSRECT'
ordinals.GDI.196='SETMETAFILEBITSBETTER'
ordinals.GDI.201='DMBITBLT'
ordinals.GDI.202='DMCOLORINFO'
ordinals.GDI.206='DMENUMDFONTS'
ordinals.GDI.207='DMENUMOBJ'
ordinals.GDI.208='DMOUTPUT'
ordinals.GDI.209='DMPIXEL'
ordinals.GDI.210='DMREALIZEOBJECT'
ordinals.GDI.211='DMSTRBLT'
ordinals.GDI.212='DMSCANLR'
ordinals.GDI.213='BRUTE'
ordinals.GDI.214='DMEXTTEXTOUT'
ordinals.GDI.215='DMGETCHARWIDTH'
ordinals.GDI.216='DMSTRETCHBLT'
ordinals.GDI.217='DMDIBBITS'
ordinals.GDI.218='DMSTRETCHDIBITS'
ordinals.GDI.219='DMSETDIBTODEV'
ordinals.GDI.220='DMTRANSPOSE'
ordinals.GDI.230='CREATEPQ'
ordinals.GDI.231='MINPQ'
ordinals.GDI.232='EXTRACTPQ'
ordinals.GDI.233='INSERTPQ'
ordinals.GDI.234='SIZEPQ'
ordinals.GDI.235='DELETEPQ'
ordinals.GDI.240='OPENJOB'
ordinals.GDI.241='WRITESPOOL'
ordinals.GDI.242='WRITEDIALOG'
ordinals.GDI.243='CLOSEJOB'
ordinals.GDI.244='DELETEJOB'
ordinals.GDI.245='GETSPOOLJOB'
ordinals.GDI.246='STARTSPOOLPAGE'
ordinals.GDI.247='ENDSPOOLPAGE'
ordinals.GDI.253='DELETESPOOLPAGE'
ordinals.GDI.254='SPOOLFILE'
ordinals.GDI.307='GETCHARABCWIDTHS'
ordinals.GDI.308='GETOUTLINETEXTMETRICS'
ordinals.GDI.309='GETGLYPHOUTLINE'
ordinals.GDI.310='CREATESCALABLEFONTRESOURCE'
ordinals.GDI.311='GETFONTDATA'
ordinals.GDI.313='GETRASTERIZERCAPS'
ordinals.GDI.330='ENUMFONTFAMILIES'
ordinals.GDI.332='GETKERNINGPAIRS'
ordinals.GDI.345='GETTEXTALIGN'
ordinals.GDI.346='SETTEXTALIGN'
ordinals.GDI.348='CHORD'
ordinals.GDI.349='SETMAPPERFLAGS'
ordinals.GDI.350='GETCHARWIDTH'
ordinals.GDI.351='EXTTEXTOUT'
ordinals.GDI.353='GETASPECTRATIOFILTER'
ordinals.GDI.360='CREATEPALETTE'
ordinals.GDI.363='GETPALETTEENTRIES'
ordinals.GDI.364='SETPALETTEENTRIES'
ordinals.GDI.366='UPDATECOLORS'
ordinals.GDI.367='ANIMATEPALETTE'
ordinals.GDI.368='RESIZEPALETTE'
ordinals.GDI.370='GETNEARESTPALETTEINDEX'
ordinals.GDI.372='EXTFLOODFILL'
ordinals.GDI.373='SETSYSTEMPALETTEUSE'
ordinals.GDI.374='GETSYSTEMPALETTEUSE'
ordinals.GDI.375='GETSYSTEMPALETTEENTRIES'
ordinals.GDI.376='RESETDC'
ordinals.GDI.377='STARTDOC'
ordinals.GDI.378='ENDDOC'
ordinals.GDI.379='STARTPAGE'
ordinals.GDI.380='ENDPAGE'
ordinals.GDI.381='SETABORTPROC'
ordinals.GDI.382='ABORTDOC'
ordinals.GDI.439='STRETCHDIBITS'
ordinals.GDI.440='SETDIBITS'
ordinals.GDI.441='GETDIBITS'
ordinals.GDI.442='CREATEDIBITMAP'
ordinals.GDI.443='SETDIBITSTODEVICE'
ordinals.GDI.444='CREATEROUNDRECTRGN'
ordinals.GDI.445='CREATEDIBPATTERNBRUSH'
ordinals.GDI.450='POLYPOLYGON'
ordinals.GDI.451='CREATEPOLYPOLYGONRGN'
ordinals.GDI.462='ISGDIOBJECT'
ordinals.GDI.465='RECTVISIBLE_EHH'
ordinals.GDI.466='RECTINREGION_EHH'
ordinals.GDI.468='GETBITMAPDIMENSIONEX'
ordinals.GDI.469='GETBRUSHORGEX'
ordinals.GDI.470='GETCURRENTPOSITIONEX'
ordinals.GDI.471='GETTEXTEXTENTPOINT'
ordinals.GDI.472='GETVIEWPORTEXTEX'
ordinals.GDI.473='GETVIEWPORTORGEX'
ordinals.GDI.474='GETWINDOWEXTEX'
ordinals.GDI.475='GETWINDOWORGEX'
ordinals.GDI.476='OFFSETVIEWPORTORGEX'
ordinals.GDI.477='OFFSETWINDOWORGEX'
ordinals.GDI.478='SETBITMAPDIMENSIONEX'
ordinals.GDI.479='SETVIEWPORTEXTEX'
ordinals.GDI.480='SETVIEWPORTORGEX'
ordinals.GDI.481='SETWINDOWEXTEX'
ordinals.GDI.482='SETWINDOWORGEX'
ordinals.GDI.483='MOVETOEX'
ordinals.GDI.484='SCALEVIEWPORTEXTEX'
ordinals.GDI.485='SCALEWINDOWEXTEX'
ordinals.GDI.486='GETASPECTRATIOFILTEREX'
ordinals.USER.1='MESSAGEBOX'
ordinals.USER.5='INITAPP'
ordinals.USER.6='POSTQUITMESSAGE'
ordinals.USER.7='EXITWINDOWS'
ordinals.USER.10='SETTIMER'
ordinals.USER.12='KILLTIMER'
ordinals.USER.13='GETTICKCOUNT'
ordinals.USER.15='GETCURRENTTIME'
ordinals.USER.16='CLIPCURSOR'
ordinals.USER.17='GETCURSORPOS'
ordinals.USER.18='SETCAPTURE'
ordinals.USER.19='RELEASECAPTURE'
ordinals.USER.20='SETDOUBLECLICKTIME'
ordinals.USER.21='GETDOUBLECLICKTIME'
ordinals.USER.22='SETFOCUS'
ordinals.USER.23='GETFOCUS'
ordinals.USER.24='REMOVEPROP'
ordinals.USER.25='GETPROP'
ordinals.USER.26='SETPROP'
ordinals.USER.27='ENUMPROPS'
ordinals.USER.28='CLIENTTOSCREEN'
ordinals.USER.29='SCREENTOCLIENT'
ordinals.USER.30='WINDOWFROMPOINT'
ordinals.USER.31='ISICONIC'
ordinals.USER.32='GETWINDOWRECT'
ordinals.USER.33='GETCLIENTRECT'
ordinals.USER.34='ENABLEWINDOW'
ordinals.USER.35='ISWINDOWENABLED'
ordinals.USER.36='GETWINDOWTEXT'
ordinals.USER.37='SETWINDOWTEXT'
ordinals.USER.38='GETWINDOWTEXTLENGTH'
ordinals.USER.39='BEGINPAINT'
ordinals.USER.40='ENDPAINT'
ordinals.USER.41='CREATEWINDOW'
ordinals.USER.42='SHOWWINDOW'
ordinals.USER.43='CLOSEWINDOW'
ordinals.USER.44='OPENICON'
ordinals.USER.45='BRINGWINDOWTOTOP'
ordinals.USER.46='GETPARENT'
ordinals.USER.47='ISWINDOW'
ordinals.USER.48='ISCHILD'
ordinals.USER.49='ISWINDOWVISIBLE'
ordinals.USER.50='FINDWINDOW'
ordinals.USER.52='ANYPOPUP'
ordinals.USER.53='DESTROYWINDOW'
ordinals.USER.54='ENUMWINDOWS'
ordinals.USER.55='ENUMCHILDWINDOWS'
ordinals.USER.56='MOVEWINDOW'
ordinals.USER.57='REGISTERCLASS'
ordinals.USER.58='GETCLASSNAME'
ordinals.USER.59='SETACTIVEWINDOW'
ordinals.USER.60='GETACTIVEWINDOW'
ordinals.USER.61='SCROLLWINDOW'
ordinals.USER.62='SETSCROLLPOS'
ordinals.USER.63='GETSCROLLPOS'
ordinals.USER.64='SETSCROLLRANGE'
ordinals.USER.65='GETSCROLLRANGE'
ordinals.USER.66='GETDC'
ordinals.USER.67='GETWINDOWDC'
ordinals.USER.68='RELEASEDC'
ordinals.USER.69='SETCURSOR'
ordinals.USER.70='SETCURSORPOS'
ordinals.USER.71='SHOWCURSOR'
ordinals.USER.72='SETRECT'
ordinals.USER.73='SETRECTEMPTY'
ordinals.USER.74='COPYRECT'
ordinals.USER.75='ISRECTEMPTY'
ordinals.USER.76='PTINRECT'
ordinals.USER.77='OFFSETRECT'
ordinals.USER.78='INFLATERECT'
ordinals.USER.79='INTERSECTRECT'
ordinals.USER.80='UNIONRECT'
ordinals.USER.81='FILLRECT'
ordinals.USER.82='INVERTRECT'
ordinals.USER.83='FRAMERECT'
ordinals.USER.84='DRAWICON'
ordinals.USER.85='DRAWTEXT'
ordinals.USER.87='DIALOGBOX'
ordinals.USER.88='ENDDIALOG'
ordinals.USER.89='CREATEDIALOG'
ordinals.USER.90='ISDIALOGMESSAGE'
ordinals.USER.91='GETDLGITEM'
ordinals.USER.92='SETDLGITEMTEXT'
ordinals.USER.93='GETDLGITEMTEXT'
ordinals.USER.94='SETDLGITEMINT'
ordinals.USER.95='GETDLGITEMINT'
ordinals.USER.96='CHECKRADIOBUTTON'
ordinals.USER.97='CHECKDLGBUTTON'
ordinals.USER.98='ISDLGBUTTONCHECKED'
ordinals.USER.99='DLGDIRSELECT'
ordinals.USER.100='DLGDIRLIST'
ordinals.USER.101='SENDDLGITEMMESSAGE'
ordinals.USER.102='ADJUSTWINDOWRECT'
ordinals.USER.103='MAPDIALOGRECT'
ordinals.USER.104='MESSAGEBEEP'
ordinals.USER.105='FLASHWINDOW'
ordinals.USER.106='GETKEYSTATE'
ordinals.USER.107='DEFWINDOWPROC'
ordinals.USER.108='GETMESSAGE'
ordinals.USER.109='PEEKMESSAGE'
ordinals.USER.110='POSTMESSAGE'
ordinals.USER.111='SENDMESSAGE'
ordinals.USER.112='WAITMESSAGE'
ordinals.USER.113='TRANSLATEMESSAGE'
ordinals.USER.114='DISPATCHMESSAGE'
ordinals.USER.115='REPLYMESSAGE'
ordinals.USER.116='POSTAPPMESSAGE'
ordinals.USER.118='REGISTERWINDOWMESSAGE'
ordinals.USER.119='GETMESSAGEPOS'
ordinals.USER.120='GETMESSAGETIME'
ordinals.USER.121='SETWINDOWSHOOK'
ordinals.USER.122='CALLWINDOWPROC'
ordinals.USER.123='CALLMSGFILTER'
ordinals.USER.124='UPDATEWINDOW'
ordinals.USER.125='INVALIDATERECT'
ordinals.USER.126='INVALIDATERGN'
ordinals.USER.127='VALIDATERECT'
ordinals.USER.128='VALIDATERGN'
ordinals.USER.129='GETCLASSWORD'
ordinals.USER.130='SETCLASSWORD'
ordinals.USER.131='GETCLASSLONG'
ordinals.USER.132='SETCLASSLONG'
ordinals.USER.133='GETWINDOWWORD'
ordinals.USER.134='SETWINDOWWORD'
ordinals.USER.135='GETWINDOWLONG'
ordinals.USER.136='SETWINDOWLONG'
ordinals.USER.137='OPENCLIPBOARD'
ordinals.USER.138='CLOSECLIPBOARD'
ordinals.USER.139='EMPTYCLIPBOARD'
ordinals.USER.140='GETCLIPBOARDOWNER'
ordinals.USER.141='SETCLIPBOARDDATA'
ordinals.USER.142='GETCLIPBOARDDATA'
ordinals.USER.143='COUNTCLIPBOARDFORMATS'
ordinals.USER.144='ENUMCLIPBOARDFORMATS'
ordinals.USER.145='REGISTERCLIPBOARDFORMAT'
ordinals.USER.146='GETCLIPBOARDFORMATNAME'
ordinals.USER.147='SETCLIPBOARDVIEWER'
ordinals.USER.148='GETCLIPBOARDVIEWER'
ordinals.USER.149='CHANGECLIPBOARDCHAIN'
ordinals.USER.150='LOADMENU'
ordinals.USER.151='CREATEMENU'
ordinals.USER.152='DESTROYMENU'
ordinals.USER.153='CHANGEMENU'
ordinals.USER.154='CHECKMENUITEM'
ordinals.USER.155='ENABLEMENUITEM'
ordinals.USER.156='GETSYSTEMMENU'
ordinals.USER.157='GETMENU'
ordinals.USER.158='SETMENU'
ordinals.USER.159='GETSUBMENU'
ordinals.USER.160='DRAWMENUBAR'
ordinals.USER.161='GETMENUSTRING'
ordinals.USER.162='HILITEMENUITEM'
ordinals.USER.163='CREATECARET'
ordinals.USER.164='DESTROYCARET'
ordinals.USER.165='SETCARETPOS'
ordinals.USER.166='HIDECARET'
ordinals.USER.167='SHOWCARET'
ordinals.USER.168='SETCARETBLINKTIME'
ordinals.USER.169='GETCARETBLINKTIME'
ordinals.USER.170='ARRANGEICONICWINDOWS'
ordinals.USER.171='WINHELP'
ordinals.USER.173='LOADCURSOR'
ordinals.USER.174='LOADICON'
ordinals.USER.175='LOADBITMAP'
ordinals.USER.176='LOADSTRING'
ordinals.USER.177='LOADACCELERATORS'
ordinals.USER.178='TRANSLATEACCELERATOR'
ordinals.USER.179='GETSYSTEMMETRICS'
ordinals.USER.180='GETSYSCOLOR'
ordinals.USER.181='SETSYSCOLORS'
ordinals.USER.183='GETCARETPOS'
ordinals.USER.184='QUERYSENDMESSAGE'
ordinals.USER.185='GRAYSTRING'
ordinals.USER.186='SWAPMOUSEBUTTON'
ordinals.USER.188='SETSYSMODALWINDOW'
ordinals.USER.189='GETSYSMODALWINDOW'
ordinals.USER.190='GETUPDATERECT'
ordinals.USER.191='CHILDWINDOWFROMPOINT'
ordinals.USER.192='INSENDMESSAGE'
ordinals.USER.193='ISCLIPBOARDFORMATAVAILABLE'
ordinals.USER.194='DLGDIRSELECTCOMBOBOX'
ordinals.USER.195='DLGDIRLISTCOMBOBOX'
ordinals.USER.196='TABBEDTEXTOUT'
ordinals.USER.197='GETTABBEDTEXTEXTENT'
ordinals.USER.200='OPENCOMM'
ordinals.USER.201='SETCOMMSTATE'
ordinals.USER.202='GETCOMMSTATE'
ordinals.USER.203='GETCOMMERROR'
ordinals.USER.204='READCOMM'
ordinals.USER.205='WRITECOMM'
ordinals.USER.206='TRANSMITCOMMCHAR'
ordinals.USER.207='CLOSECOMM'
ordinals.USER.208='SETCOMMEVENTMASK'
ordinals.USER.209='GETCOMMEVENTMASK'
ordinals.USER.210='SETCOMMBREAK'
ordinals.USER.211='CLEARCOMMBREAK'
ordinals.USER.212='UNGETCOMMCHAR'
ordinals.USER.213='BUILDCOMMDCB'
ordinals.USER.214='ESCAPECOMMFUNCTION'
ordinals.USER.215='FLUSHCOMM'
ordinals.USER.218='DIALOGBOXINDIRECT'
ordinals.USER.219='CREATEDIALOGINDIRECT'
ordinals.USER.220='LOADMENUINDIRECT'
ordinals.USER.221='SCROLLDC'
ordinals.USER.222='GETKEYBOARDSTATE'
ordinals.USER.223='SETKEYBOARDSTATE'
ordinals.USER.224='GETWINDOWTASK'
ordinals.USER.225='ENUMTASKWINDOWS'
ordinals.USER.226='LOCKINPUT'
ordinals.USER.227='GETNEXTDLGGROUPITEM'
ordinals.USER.228='GETNEXTDLGTABITEM'
ordinals.USER.229='GETTOPWINDOW'
ordinals.USER.230='GETNEXTWINDOW'
ordinals.USER.231='GETSYSTEMDEBUGSTATE'
ordinals.USER.232='SETWINDOWPOS'
ordinals.USER.233='SETPARENT'
ordinals.USER.234='UNHOOKWINDOWSHOOK'
ordinals.USER.235='DEFHOOKPROC'
ordinals.USER.236='GETCAPTURE'
ordinals.USER.237='GETUPDATERGN'
ordinals.USER.238='EXCLUDEUPDATERGN'
ordinals.USER.239='DIALOGBOXPARAM'
ordinals.USER.240='DIALOGBOXINDIRECTPARAM'
ordinals.USER.241='CREATEDIALOGPARAM'
ordinals.USER.242='CREATEDIALOGINDIRECTPARAM'
ordinals.USER.243='GETDIALOGBASEUNITS'
ordinals.USER.244='EQUALRECT'
ordinals.USER.245='ENABLECOMMNOTIFICATION'
ordinals.USER.246='EXITWINDOWSEXEC'
ordinals.USER.247='GETCURSOR'
ordinals.USER.248='GETOPENCLIPBOARDWINDOW'
ordinals.USER.249='GETASYNCKEYSTATE'
ordinals.USER.250='GETMENUSTATE'
ordinals.USER.251='SENDDRIVERMESSAGE'
ordinals.USER.252='OPENDRIVER'
ordinals.USER.253='CLOSEDRIVER'
ordinals.USER.254='GETDRIVERMODULEHANDLE'
ordinals.USER.255='DEFDRIVERPROC'
ordinals.USER.256='GETDRIVERINFO'
ordinals.USER.257='GETNEXTDRIVER'
ordinals.USER.258='MAPWINDOWPOINTS'
ordinals.USER.259='BEGINDEFERWINDOWPOS'
ordinals.USER.260='DEFERWINDOWPOS'
ordinals.USER.261='ENDDEFERWINDOWPOS'
ordinals.USER.262='GETWINDOW'
ordinals.USER.263='GETMENUITEMCOUNT'
ordinals.USER.264='GETMENUITEMID'
ordinals.USER.265='SHOWOWNEDPOPUPS'
ordinals.USER.266='SETMESSAGEQUEUE'
ordinals.USER.267='SHOWSCROLLBAR'
ordinals.USER.268='GLOBALADDATOM'
ordinals.USER.269='GLOBALDELETEATOM'
ordinals.USER.270='GLOBALFINDATOM'
ordinals.USER.271='GLOBALGETATOMNAME'
ordinals.USER.272='ISZOOMED'
ordinals.USER.275='REPAINTSCREEN'
ordinals.USER.277='GETDLGCTRLID'
ordinals.USER.282='SELECTPALETTE'
ordinals.USER.283='REALIZEPALETTE'
ordinals.USER.284='GETFREESYSTEMRESOURCES'
ordinals.USER.286='GETDESKTOPWINDOW'
ordinals.USER.287='GETLASTACTIVEPOPUP'
ordinals.USER.288='GETMESSAGEEXTRAINFO'
ordinals.USER.289='KEYBD_EVENT'
ordinals.USER.290='REDRAWWINDOW'
ordinals.USER.291='SETWINDOWSHOOKEX'
ordinals.USER.292='UNHOOKWINDOWSHOOKEX'
ordinals.USER.293='CALLNEXTHOOKEX'
ordinals.USER.294='LOCKWINDOWUPDATE'
ordinals.USER.299='MOUSE_EVENT'
ordinals.USER.308='DEFDLGPROC'
ordinals.USER.309='GETCLIPCURSOR'
ordinals.USER.319='SCROLLWINDOWEX'
ordinals.USER.321='SETEVENTHOOK'
ordinals.USER.331='ENABLEHARDWAREINPUT'
ordinals.USER.334='GETQUEUESTATUS'
ordinals.USER.335='GETINPUTSTATE'
ordinals.USER.358='ISMENU'
ordinals.USER.359='GETDCEX'
ordinals.USER.368='COPYICON'
ordinals.USER.369='COPYCURSOR'
ordinals.USER.370='GETWINDOWPLACEMENT'
ordinals.USER.371='SETWINDOWPLACEMENT'
ordinals.USER.373='SUBTRACTRECT'
ordinals.USER.402='GETPRIORITYCLIPBOARDFORMAT'
ordinals.USER.403='UNREGISTERCLASS'
ordinals.USER.404='GETCLASSINFO'
ordinals.USER.406='CREATECURSOR'
ordinals.USER.407='CREATEICON'
ordinals.USER.410='INSERTMENU'
ordinals.USER.411='APPENDMENU'
ordinals.USER.412='REMOVEMENU'
ordinals.USER.413='DELETEMENU'
ordinals.USER.414='MODIFYMENU'
ordinals.USER.415='CREATEPOPUPMENU'
ordinals.USER.416='TRACKPOPUPMENU'
ordinals.USER.417='GETMENUCHECKMARKDIMENSIONS'
ordinals.USER.418='SETMENUITEMBITMAPS'
ordinals.USER.420='_WSPRINTF'
ordinals.USER.421='WVSPRINTF'
ordinals.USER.422='DLGDIRSELECTEX'
ordinals.USER.423='DLGDIRSELECTCOMBOBOXEX'
ordinals.USER.430='LSTRCMP'
ordinals.USER.431='ANSIUPPER'
ordinals.USER.432='ANSILOWER'
ordinals.USER.433='ISCHARALPHA'
ordinals.USER.434='ISCHARALPHANUMERIC'
ordinals.USER.435='ISCHARUPPER'
ordinals.USER.436='ISCHARLOWER'
ordinals.USER.437='ANSIUPPERBUFF'
ordinals.USER.438='ANSILOWERBUFF'
ordinals.USER.445='DEFFRAMEPROC'
ordinals.USER.447='DEFMDICHILDPROC'
ordinals.USER.451='TRANSLATEMDISYSACCEL'
ordinals.USER.452='CREATEWINDOWEX'
ordinals.USER.454='ADJUSTWINDOWRECTEX'
ordinals.USER.457='DESTROYICON'
ordinals.USER.458='DESTROYCURSOR'
ordinals.USER.466='DRAWFOCUSRECT'
ordinals.USER.471='LSTRCMPI'
ordinals.USER.472='ANSINEXT'
ordinals.USER.473='ANSIPREV'
ordinals.USER.481='HARDWARE_EVENT'
ordinals.USER.482='ENABLESCROLLBAR'
ordinals.USER.483='SYSTEMPARAMETERSINFO'
ordinals.USER.512='WNETGETCONNECTION'
ordinals.USER.517='WNETADDCONNECTION'
ordinals.USER.518='WNETCANCELCONNECTION'
ordinals.SOUND.1='OPENSOUND'
ordinals.SOUND.2='CLOSESOUND'
ordinals.SOUND.3='SETVOICEQUEUESIZE'
ordinals.SOUND.4='SETVOICENOTE'
ordinals.SOUND.5='SETVOICEACCENT'
ordinals.SOUND.6='SETVOICEENVELOPE'
ordinals.SOUND.7='SETSOUNDNOISE'
ordinals.SOUND.8='SETVOICESOUND'
ordinals.SOUND.9='STARTSOUND'
ordinals.SOUND.10='STOPSOUND'
ordinals.SOUND.11='WAITSOUNDSTATE'
ordinals.SOUND.12='SYNCALLVOICES'
ordinals.SOUND.13='COUNTVOICENOTES'
ordinals.SOUND.14='GETTHRESHOLDEVENT'
ordinals.SOUND.15='GETTHRESHOLDSTATUS'
ordinals.SOUND.16='SETVOICETHRESHOLD'
ordinals.KEYBOARD.4='TOASCII'
ordinals.KEYBOARD.5='ANSITOOEM'
ordinals.KEYBOARD.6='OEMTOANSI'
ordinals.KEYBOARD.128='OEMKEYSCAN'
ordinals.KEYBOARD.129='VKKEYSCAN'
ordinals.KEYBOARD.130='GETKEYBOARDTYPE'
ordinals.KEYBOARD.131='MAPVIRTUALKEY'
ordinals.KEYBOARD.132='GETKBCODEPAGE'
ordinals.KEYBOARD.133='GETKEYNAMETEXT'
ordinals.KEYBOARD.134='ANSITOOEMBUFF'
ordinals.KEYBOARD.135='OEMTOANSIBUFF'
ordinals.KEYBOARD.137='GETBIOSKEYPROC'
ordinals.GDI.5='SETRELABS'
ordinals.GDI.46='BITMAPBITS'
ordinals.GDI.46='__GP'
ordinals.GDI.73='EXCLUDEVISRECT'
ordinals.GDI.86='GETRELABS'
ordinals.GDI.98='INTERSECTVISRECT'
ordinals.GDI.102='OFFSETVISRGN'
ordinals.GDI.105='SELECTVISRGN'
ordinals.GDI.117='SETDCORG'
ordinals.GDI.118='INTERNALCREATEDC'
ordinals.GDI.121='DEATH'
ordinals.GDI.122='RESURRECTION'
ordinals.GDI.129='SAVEVISRGN'
ordinals.GDI.130='RESTOREVISRGN'
ordinals.GDI.131='INQUIREVISRGN'
ordinals.GDI.135='SCANLR'
ordinals.GDI.137='GSV'
ordinals.GDI.138='DPXLATE'
ordinals.GDI.139='SETWINVIEWEXT'
ordinals.GDI.140='SCALEEXT'
ordinals.GDI.141='WORDSET'
ordinals.GDI.142='RECTSTUFF'
ordinals.GDI.143='OFFSETORG'
ordinals.GDI.157='COMPATIBLEBITMAP'
ordinals.GDI.158='ENUMCALLBACK'
ordinals.GDI.164='PIXTOLINE'
ordinals.GDI.169='ISDCDIRTY'
ordinals.GDI.170='SETDCSTATUS'
ordinals.GDI.171='LVBUNION'
ordinals.GDI.173='GETCLIPRGN'
ordinals.GDI.177='RCOS'
ordinals.GDI.178='RSIN'
ordinals.GDI.179='GETDCSTATE'
ordinals.GDI.180='SETDCSTATE'
ordinals.GDI.184='STUFFVISIBLE'
ordinals.GDI.185='STUFFINREGION'
ordinals.GDI.186='DELETEABOVELINEFONTS'
ordinals.GDI.188='GETTEXTEXTENTEX'
ordinals.GDI.190='SETDCHOOK'
ordinals.GDI.191='GETDCHOOK'
ordinals.GDI.192='SETHOOKFLAGS'
ordinals.GDI.195='SELECTBITMAP'
ordinals.GDI.248='QUERYJOB'
ordinals.GDI.250='COPY'
ordinals.GDI.300='ENGINEENUMERATEFONT'
ordinals.GDI.301='ENGINEDELETEFONT'
ordinals.GDI.302='ENGINEREALIZEFONT'
ordinals.GDI.303='ENGINEGETCHARWIDTH'
ordinals.GDI.304='ENGINESETFONTCONTEXT'
ordinals.GDI.305='ENGINEGETGLYPHBMP'
ordinals.GDI.306='ENGINEMAKEFONTDIR'
ordinals.GDI.312='CONVERTOUTLINEFONTFILE'
ordinals.GDI.314='ENGINEEXTTEXTOUT'
ordinals.GDI.331='ENUMFONTSINTERNAL'
ordinals.GDI.347='MFDRAWTEXT'
ordinals.GDI.352='GETPHYSICALFONTHANDLE'
ordinals.GDI.354='SHRINKGDIHEAP'
ordinals.GDI.355='FTRAPPING0'
ordinals.GDI.361='GDISELECTPALETTE'
ordinals.GDI.362='GDIREALIZEPALETTE'
ordinals.GDI.365='REALIZEDEFAULTPALETTE'
ordinals.GDI.400='FASTWINDOWFRAME'
ordinals.GDI.401='GDIMOVEBITMAP'
ordinals.GDI.403='GDIINIT2'
ordinals.GDI.405='FINALGDIINIT'
ordinals.GDI.406='CREATEREALBITMAPINDIRECT'
ordinals.GDI.407='CREATEUSERBITMAP'
ordinals.GDI.408='CREATEREALBITMAP'
ordinals.GDI.409='CREATEUSERDISCARDABLEBITMAP'
ordinals.GDI.410='ISVALIDMETAFILE'
ordinals.GDI.411='GETCURLOGFONT'
ordinals.GDI.412='ISDCCURRENTPALETTE'
ordinals.GDI.449='DEVICECOLORMATCH'
ordinals.GDI.452='GDISEEGDIDO'
ordinals.GDI.460='GDITASKTERMINATION'
ordinals.GDI.461='SETOBJECTOWNER'
ordinals.GDI.463='MAKEOBJECTPRIVATE'
ordinals.GDI.464='FIXUPBOGUSPUBLISHERMETAFILE'
ordinals.GDI.467='UNICODETOANSI'
ordinals.GDI.500='ENGINEENUMERATEFONT'
ordinals.GDI.501='ENGINEDELETEFONT'
ordinals.GDI.502='ENGINEREALIZEFONT'
ordinals.GDI.503='ENGINEGETCHARWIDTH'
ordinals.GDI.504='ENGINESETFONTCONTEXT'
ordinals.GDI.505='ENGINEGETGLYPHBMP'
ordinals.GDI.506='ENGINEMAKEFONTDIR'
ordinals.KEYBOARD.=1'Inquire'
ordinals.KEYBOARD.=2'Enable'
ordinals.KEYBOARD.=3'Disable'
ordinals.KEYBOARD.=7'SetSpeed'
ordinals.KEYBOARD.=100'ScreenSwitchEnable'
ordinals.KEYBOARD.=126'GetTableSeg'
ordinals.KEYBOARD.=127'NewTable'
ordinals.KEYBOARD.=136'EnableKBSysReq'
ordinals.KERNEL.2='EXITKERNEL'
ordinals.KERNEL.14='LOCALNOTIFY'
ordinals.KERNEL.26='GLOBALFREEALL'
ordinals.KERNEL.28='GLOBALMASTERHANDLE'
ordinals.KERNEL.31='POSTEVENT'
ordinals.KERNEL.32='SETPRIORITY'
ordinals.KERNEL.33='LOCKCURRENTTASK'
ordinals.KERNEL.34='SETTASKQUEUE'
ordinals.KERNEL.35='GETTASKQUEUE'
ordinals.KERNEL.38='SETTASKSIGNALPROC'
ordinals.KERNEL.41='ENABLEDOS'
ordinals.KERNEL.42='DISABLEDOS'
ordinals.KERNEL.53='CALLPROCINSTANCE'
ordinals.KERNEL.75='OPENPATHNAME'
ordinals.KERNEL.76='DELETEPATHNAME'
ordinals.KERNEL.98='GETLASTDISKCHANGE'
ordinals.KERNEL.99='GETLPERRMODE'
ordinals.KERNEL.101='NOHOOKDOSCALL'
ordinals.KERNEL.105='GETEXEVERSION'
ordinals.KERNEL.116='INITLIB'
ordinals.KERNEL.117='OLDYIELD'
ordinals.KERNEL.118='GETTASKQUEUEDS'
ordinals.KERNEL.119='GETTASKQUEUEES'
ordinals.KERNEL.120='UNDEFDYNLINK'
ordinals.KERNEL.122='ISTASKLOCKED'
ordinals.KERNEL.123='KBDRST'
ordinals.KERNEL.124='ENABLEKERNEL'
ordinals.KERNEL.125='DISABLEKERNEL'
ordinals.KERNEL.126='MEMORYFREED'
ordinals.KERNEL.130='FILECDR'
ordinals.KERNEL.133='GETEXEPTR'
ordinals.KERNEL.138='GETHEAPSPACES'
ordinals.KERNEL.139='DOSIGNAL'
ordinals.KERNEL.140='SETSIGHANDLER'
ordinals.KERNEL.141='INITTASK1'
ordinals.KERNEL.151='WINOLDAPCALL'
ordinals.KERNEL.155='GETTASKDS'
ordinals.KERNEL.157='GETCURPID'
ordinals.KERNEL.158='ISWINOLDAPTASK'
ordinals.KERNEL.159='GLOBALHANDLENORIP'
ordinals.KERNEL.160='EMSCOPY'
ordinals.KERNEL.161='LOCALCOUNTFREE'
ordinals.KERNEL.162='LOCALHEAPSIZE'
ordinals.KERNEL.165='A20PROC'
ordinals.KERNEL.167='GETEXPWINVER'
ordinals.KERNEL.168='DIRECTRESALLOC'
ordinals.KERNEL.201='REPLACEINST'
ordinals.KERNEL.202='REGISTERPTRACE'
ordinals.KERNEL.206='ALLOCSELECTORARRAY'
ordinals.KERNEL.286='ROM_RESERVEDLZDECODE'
ordinals.KERNEL.311='GETSETKERNELDOSPROC'
ordinals.KERNEL.312='FARVALIDATEPOINTER'
ordinals.KERNEL.314='DEBUGDEFINESEGMENT'
ordinals.KERNEL.315='WRITEOUTPROFILES'
ordinals.KERNEL.318='FATALEXITHOOK'
ordinals.KERNEL.319='FLUSHCACHEDFILEHANDLE'
ordinals.KERNEL.323='ISROMMODULE'
ordinals.KERNEL.326='ISROMFILE'
ordinals.KERNEL.327='K327=HANDLEPARAMERROR'
ordinals.KERNEL.328='_DebugOutput'
ordinals.KERNEL.329='K329=DEBUGFILLBUFFER'
ordinals.KERNEL.332='THHOOK'
ordinals.KERNEL.338='HASGPHANDLER'
ordinals.KERNEL.341='TOOLHELPHOOK'
ordinals.KERNEL.342='__GP'
ordinals.KERNEL.345='ISSHAREDSELECTOR'
ordinals.KERNEL.351='BUNNY_351'
ordinals.KERNEL.354='GETAPPCOMPATFLAGS'
ordinals.KERNEL.403='K403=FARSETOWNER'
ordinals.KERNEL.404='K404=FARGETOWNER'
ordinals.SOUND.17='DOBEEP'
ordinals.SOUND.18='MYOPENSOUND'
ordinals.USER.2='OLDEXITWINDOWS'
ordinals.USER.3='ENABLEOEMLAYER'
ordinals.USER.4='DISABLEOEMLAYER'
ordinals.USER.11='SETSYSTEMTIMER'
ordinals.USER.14='GETTIMERRESOLUTION'
ordinals.USER.51='BEAR51=ISTWOBYTECHARPREFIX'
ordinals.USER.86='BEAR86=ICONSIZE'
ordinals.USER.117='GETTASKFROMHWND'
ordinals.USER.172='SWITCHTOTHISWINDOW'
ordinals.USER.182='BEAR182=KILLSYSTEMTIMER'
ordinals.USER.187='ENDMENU'
ordinals.USER.198='CASCADECHILDWINDOWS'
ordinals.USER.199='TILECHILDWINDOWS'
ordinals.USER.216='USERSEEUSERDO'
ordinals.USER.217='LOOKUPMENUHANDLE'
ordinals.USER.273='CONTROLPANELINFO'
ordinals.USER.274='GETNEXTQUEUEWINDOW'
ordinals.USER.276='LOCKMYTASK'
ordinals.USER.278='GETDESKTOPHWND'
ordinals.USER.279='OLDSETDESKPATTERN'
ordinals.USER.280='SETSYSTEMMENU'
ordinals.USER.285='BEAR285=OLDSETDESKWALLPAPER'
ordinals.USER.301='BOZOSLIVEHERE'
ordinals.USER.302='BEAR302=STATICWNDPROC'
ordinals.USER.303='BEAR303=BUTTONWNDPROC'
ordinals.USER.304='BEAR304=SBWNDPROC'
ordinals.USER.305='BEAR305=DESKTOPWNDPROC'
ordinals.USER.306='BEAR306=MENUWINDOWPROC'
ordinals.USER.307='BEAR307=LBOXCTLWNDPROC'
ordinals.USER.310='BEAR310=CONTSCROLL'
ordinals.USER.311='CARETBLINKPROC'
ordinals.USER.312='SENDMESSAGE2'
ordinals.USER.313='POSTMESSAGE2'
ordinals.USER.314='SIGNALPROC'
ordinals.USER.315='XCSTODS'
ordinals.USER.316='INTERNALBEGINPAINT'
ordinals.USER.320='SYSERRORBOX'
ordinals.USER.322='WINOLDAPPHACKOMATIC'
ordinals.USER.323='GETMESSAGE2'
ordinals.USER.324='FILLWINDOW'
ordinals.USER.325='PAINTRECT'
ordinals.USER.326='GETCONTROLBRUSH'
ordinals.USER.327='KILLTIMER2'
ordinals.USER.328='SETTIMER2'
ordinals.USER.329='BEAR329=MENUITEMSTATE'
ordinals.USER.330='SETGETKBDSTATE'
ordinals.USER.332='USERYIELD'
ordinals.USER.333='ISUSERIDLE'
ordinals.USER.336='LOADCURSORICONHANDLER'
ordinals.USER.337='GETMOUSEEVENTPROC'
ordinals.USER.338='BEAR338=DESTROYTASKWINDOWSENUM'
ordinals.USER.339='BEAR339=ACTIVATEAPP'
ordinals.USER.340='BEAR340=SOW_SENDZOOM'
ordinals.USER.341='_FFFE_FARFRAME'
ordinals.USER.342='BEAR342=BROADCASTPROC'
ordinals.USER.343='GETFILEPORTNAME'
ordinals.USER.344='BEAR344=COMBOBOXCTLWNDPROC'
ordinals.USER.345='BEAR345=TITLEWNDPROC'
ordinals.USER.346='FILEPORTDLGPROC'
ordinals.USER.347='*EAR347=SWITCHWNDPROC'
ordinals.USER.348='BEAR348=FCHILDVISIBLE'
ordinals.USER.349='BEAR349=DRAWFRAME'
ordinals.USER.350='BEAR350=LOOKUPMENUITEM'
ordinals.USER.351='BEAR351=RECALCTABSTRINGS'
ordinals.USER.352='BEAR352=BTNGRAYSTRINGTEXTOUT'
ordinals.USER.353='BEAR353=LBGRAYPRINT'
ordinals.USER.354='BEAR354=TABTHETEXTOUTFORWIMPS'
ordinals.USER.355='BROADCASTMESSAGE'
ordinals.USER.356='LOADDIBCURSORHANDLER'
ordinals.USER.357='LOADDIBICONHANDLER'
ordinals.USER.358='BEAR358=FREEITEM'
ordinals.USER.362='DCHOOK'
ordinals.USER.363='BEAR363=FNENUMTASK'
ordinals.USER.364='BEAR364=GRAYSTATICPRINT'
ordinals.USER.365='BEAR365=IREDRAWWINDOW'
ordinals.USER.366='BEAR366=FQUERYQUITENUM'
ordinals.USER.372='GETINTERNALICONHEADER'
ordinals.USER.399='IGETEVENTHOOK'
ordinals.USER.400='FINALUSERINIT'
ordinals.USER.401='BEAR401=ANSISTRRTNS'
ordinals.USER.405='BEAR405=ANSIBUFFRTNS'
ordinals.USER.408='CREATECURSORICONINDIRECT'
ordinals.USER.409='MB_DLGPROC'
ordinals.USER.419='BEAR419=CHARRTNS'
ordinals.USER.444='BEAR444=MDICLIENTWNDPROC'
ordinals.USER.453='BEAR453=LBOXCARETBLINKER'
ordinals.USER.455='GETICONID'
ordinals.USER.456='LOADICONHANDLER'
ordinals.USER.459='DUMPICON'
ordinals.USER.460='GETINTERNALWINDOWPOS'
ordinals.USER.461='SETINTERNALWINDOWPOS'
ordinals.USER.462='CALCCHILDSCROLL'
ordinals.USER.463='SCROLLCHILDREN'
ordinals.USER.464='DRAGOBJECT'
ordinals.USER.465='DRAGDETECT'
ordinals.USER.470='STRINGFUNC'
ordinals.USER.480='GETUSERLOCALOBJTYPE'
ordinals.USER.484='__GP'
ordinals.USER.499='WNETERRORTEXT'
ordinals.USER.500='FARCALLNETDRIVER'
ordinals.USER.501='WNETOPENJOB'
ordinals.USER.502='WNETCLOSEJOB'
ordinals.USER.503='WNETABORTJOB'
ordinals.USER.504='WNETHOLDJOB'
ordinals.USER.505='WNETRELEASEJOB'
ordinals.USER.506='WNETCANCELJOB'
ordinals.USER.507='WNETSETJOBCOPIES'
ordinals.USER.508='WNETWATCHQUEUE'
ordinals.USER.509='WNETUNWATCHQUEUE'
ordinals.USER.510='WNETLOCKQUEUEDATA'
ordinals.USER.511='WNETUNLOCKQUEUEDATA'
ordinals.USER.513='WNETGETCAPS'
ordinals.USER.514='WNETDEVICEMODE'
ordinals.USER.515='WNETBROWSEDIALOG'
ordinals.USER.516='WNETGETUSER'
ordinals.USER.519='WNETGETERROR'
ordinals.USER.520='WNETGETERRORTEXT'
ordinals.USER.521='WNETENABLE'
ordinals.USER.522='WNETDISABLE'
ordinals.USER.523='WNETRESTORECONNECTION'
ordinals.USER.524='WNETWRITEJOB'
ordinals.USER.525='WNETCONNECTDIALOG'
ordinals.USER.526='WNETDISCONNECTDIALOG'
ordinals.USER.527='WNETCONNECTIONDIALOG'
ordinals.USER.528='WNETVIEWQUEUEDIALOG'
ordinals.USER.529='WNETPROPERTYDIALOG'
ordinals.USER.530='WNETGETDIRECTORYTYPE'
ordinals.USER.531='WNETDIRECTORYNOTIFY'
ordinals.USER.532='WNETGETPROPERTYTEXT'
ordinals.WINSMSG.1='WEP'
ordinals.WINSMSG.2='WINSVWINMSG'
ordinals.WINSMSG.3='WINSHOOKMSG'
ordinals.WINSMSG.4='ADDQUEUENODE'
ordinals.WINSMSG.5='DELQUEUENODE'
ordinals.WINSMSG.6='FINDQUEUENODEBYTAG'
ordinals.WINSMSG.7='FINDQUEUENODEBYHWND'
ordinals.WINSMSG.8='FINDQUEUENODEBYHCURSOR'
ordinals.WINSMSG.9='SENDSHIELDMSG'
ordinals.WINSMSG.10='WINSEXECPGM'
ordinals.WINSMSG.11='EXECPROGRAM'
ordinals.WINSMSG.12='FINDEXTENSIONINLIST'
ordinals.WINSMSG.13='DOSYSAPPEQUALS'
ordinals.WINSMSG.14='WINSSTARTSHELL'
ordinals.WINSMSG.15='CRDLGPROC'
ordinals.WINSMSG.16='VDMINIT'
ordinals.WINSMSG.17='STARTAPPS'
ordinals.WINSMSG.18='MYMESSAGEBOX'
ordinals.WINSMSG.19='SETCURRENTDIRECTORY'
ordinals.WINSMSG.20='GETCURRENTDIRECTORY'
ordinals.WINSMSG.21='DEBUGDUMPTOKERNEL'
ordinals.WINSMSG.22='_INT386'
ordinals.WINSMSG.23='WINSINITDLLGLOBAL'
ordinals.WINSMSG.24='WINSKERNELMSG'
ordinals.WINSMSG.25='DISPLAYCALLBACK'
ordinals.WINSMSG.26='VWINCLIPCALLBACK'
ordinals.WINSMSG.27='VWINDDECALLBACK'
ordinals.WINSMSG.28='ERRORDLGPROC'
ordinals.WINSMSG.29='MYSETBORDER'
ordinals.WINSMSG.30='DOSCREATEQUEUE'
ordinals.WINSMSG.31='DOSOPENQUEUE'
ordinals.WINSMSG.32='DOSCLOSEQUEUE'
ordinals.WINSMSG.33='DOSPEEKQUEUE'
ordinals.WINSMSG.34='DOSREADQUEUE'
ordinals.WINSMSG.35='DOSWRITEQUEUE'
ordinals.WINSMSG.37='CONVERTPMHTOWH'
ordinals.WINSMSG.38='GETVDMIDENTIFIER'
ordinals.SYSTEM.1='InquireSystem'
ordinals.SYSTEM.2='CreateSystemTimer'
ordinals.SYSTEM.3='KillSystemTimer'
ordinals.SYSTEM.4='EnableSystemTimers'
ordinals.SYSTEM.5='DisableSystemTimers'
ordinals.SYSTEM.6='GetSystemMsecCount'
ordinals.SYSTEM.7='Get80x87SaveSize'
ordinals.SYSTEM.8='Save80x87State'
ordinals.SYSTEM.9='Restore80x87State'
ordinals.SYSTEM.20='A20_Proc'
ordinals.ROMSYS.1='InquireSystem'
ordinals.ROMSYS.2='CreateSystemTimer'
ordinals.ROMSYS.3='KillSystemTimer'
ordinals.ROMSYS.4='EnableSystemTimers'
ordinals.ROMSYS.5='DisableSystemTimers'
ordinals.ROMSYS.6='GetSystemMsecCount'
ordinals.ROMSYS.7='Get80x87SaveSize'
ordinals.ROMSYS.8='Save80x87State'
ordinals.ROMSYS.9='Restore80x87State'
ordinals.WINSCLIP.1='WEP'
ordinals.WINSCLIP.2='Clipwos2WndProc'
ordinals.WINSCLIP.3='ClipInitDLLGlobal'
ordinals.WINSDDE.1='WEP'
ordinals.WINSDDE.2='SuperAgentProc'
ordinals.WINSDDE.3='AgentProc'
ordinals.WINSDDE.4='CloseAgentWindowsEnum'
ordinals.WINSDDE.5='FindAgentWindowEnum'
ordinals.WINSDDE.6='DDEInitDLLGlobal'
ordinals.WINSHELD.1='WINSHELDWNDPROC'
ordinals.WINSHELD.3='WINSHELDWHITEWNDPROC'
ordinals.WINSHELD.4='ENUMTOPLEVELWINDOWS'
return



