/*rexx                                                               */
/*                                                                   */
/* (C) Copyright IBM Corp. 1993                                       */
/* (C) Copyright IBM Information Solutions 1993                       */
/*                                                                    */
/* format VDD entry points */
trace 'o'

numeric digits 20
/* cache the VDD mtes */
?vdd.=''
?vbase2hmte.=''
?vbaslst.=''
k=0
address df 'cmd output .lmvo'
do i=1 to output.0-1
   if output.i='' then iterate
   parse var output.i 'hmte='hmte . . modname
   hmte=right(hmte,8,'0')
   ?vdd.hmte=modname
   j=i+1
   if word(output.j,1)='obj' then do j=j+1 by 1 while words(output.j)>1
      parse var output.j obj vsize vbase . . . vaddr pg .
      if right(pg,1)='x' then do
         k=k+1
         dbase=x2d(vbase)
         ?vbase2hmte.dbase=hmte
         ?vbaselst.k=dbase
      end /* do */
   end /* do */
   i=j
end /* do */
?vbaselst.0=k

call rxfuncadd 'sort','rxutils','rxstemsort'
call sort '?vbaselst'

/* debugging code
do i=1 to ?vbaselst.0
   x= ?vbaselst.i
   y=?vbase2hmte.x
   say d2x(x) y ?vdd.y
end /* do */
exit
end of debugging code */


say 'Virtual Device Driver Communications'
say 'VDD/VDD and VDD/OS2 entry poins'
say ''

/* first get list of open VDD handles */
proc2hdl.=''
address df 'cmd output dd _phdlvddhead l1'
z=output.0-1
parse var output.z . hvdd .
do while '#'hvdd<>'#00000000'
   address df 'cmd output dd %'hvdd 'l2'
   z=output.0-1
   parse var output.z . vddproc nexthdl .
   proc2hdl.vddproc=hvdd
   hvdd=nexthdl
end /* do */

none=0=0
/* now run the list of registered names */
address df 'cmd output dd _pvddephead l1'
z=output.0-1
parse var output.z . vddep .
do while '#'vddep<>'#00000000'
   address df 'cmd output da %'vddep
   z=output.0-1
   vname=word(output.z,2)
   address df 'cmd output dd %'vddep'+9 l3'
   z=output.0-1
   parse var output.z . vddproc hmte nextep .
   if ?vdd.hmte='' then do
      address df 'cmd output .lm' hmte
      z=output.0-1
      modname=word(output.z,4)
   end /* do */
   else modname=?vdd.hmte
   hdl=proc2hdl.vddproc
   if hdl='' then hdl='Not Open'
   else hdl='Open handle='hdl

   say ''
   say 'Registered name:'vname hdl
   say '  Last VDD to register this name='modname 'hmte='hmte
   do while '#'vddproc<>'#00000000'
      address df 'cmd output dd %'vddproc 'l3'
      z=output.0-1
      parse var output.z . vddvdd vddos2 nextproc .
      say '  VDD/VDD EP=%'vddvdd 'VDD/OS2 EP=%'vddos2
      vddproc=nextproc
   end /* do */
   vddep=nextep
   none=0=1
end /* do */
if none then say '   None is registered'

say ''
say 'PDD/VDD entry points'
say ''
address df 'cmd output dd _ppddephead l1'
z=output.0-1
parse var output.z . pddep .
none=0=0
do while '#'pddep<>'#00000000'
   address df 'cmd output da %'pddep
   z=output.0-1
   pname=word(output.z,2)
   address df 'cmd output dd %'pddep'+9 l3'
   z=output.0-1
   parse var output.z . off sel nextpdd .
   if datatype(pname,'a') then do
      say 'Registered name:'pname 'PDD Entry point='sel':'off
      pddep=nextpdd
      none=0=1
   end
   else pddep='00000000'
end /* do */
if none then say '   None is registered'

address df 'cmd output .p#'
z=output.0-1
parse var output.z ?.slot ?.pid ?.ppid ?.csid ?.ord ?.sta ?.pri ?.ptsd ?.pptda ?.ptcb ?.disp ?.sg ?.name .
if ?.name='' then do
   ?.name=?.sg
   ?.sg=?.disp
   ?.disp=''
end /* do */
slot=strip(?.slot,'l','*')
slot=strip(?.slot,'t','#')

say ''
if ?.name<>'*vdm' then do
   say 'Current slot is not a VDM - for further information select a VDM slot'
   exit 4
end /* do */

none=0=0
say 'VDD Interrupt handler hooks'
do i=0 to 255
   address df 'cmd output dd _apinthhead+'i't*4 l1'
   z=output.0-1
   if word(output.z,2)='00000000' then iterate
   none=0=1
   inth=c2x(bitand(x2c(word(output.z,2)),'fffffffc'x))
   type=bitand(x2c(word(output.z,2)),'00000003'x)
   desc=''
   if bitand(type,'00000001'x)='00000001'x then desc='Pre-reflection '
   if bitand(type,'00000002'x)='00000002'x then desc=desc'BP'
   if desc<>'' then desc='Type='desc
   else
   say ' '
   say '  Hooks for interrupt' right(d2x(i),2,'0') desc
   do while '#'inth<>'#00000000'
      address df 'cmd output dd' inth 'l3'
      z=output.0-1
      parse var output.z . inth asmep cep .
      say '   ASM EP=%'asmep 'C EP=%'cep vddname(asmep) vddname(cep)
   end /* do */
end /* do */
if none then say '   None is registered'


exit

vddname: procedure expose ?vbase2hmte. ?vbaselst. ?vdd.
arg addr
if left(addr,1)='F' then do
   address df 'cmd output ln %'addr
   z=output.0-1
   if word(output.z,1)='No' then return ''
   return subword(output.z,3)
end /* do */
else
x=x2d(addr)
if x< ?vbaselst.1 then return ''
z=?vbaselst.0
if x> ?vbaselst.z then return ''

do i= 1 to ?vbaselst.0
   if x<=?vbaselst.0 then leave
end /* do */

i=i-1
vbase=?vbaselst.i
hmte=?vbase2hmte.vbase
return ?vdd.hmte
